% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/boot.R
\name{ergmito_boot}
\alias{ergmito_boot}
\title{Bootstrap of ergmito}
\usage{
ergmito_boot(x, ..., R, ncpus = 1L, cl = NULL)
}
\arguments{
\item{x}{Either a formula or an object of class \link{ergmito}.}

\item{...}{Additional arguments passed to the method.}

\item{R}{Integer. Number of replicates}

\item{ncpus}{Integer Number of CPUs to use. Only recommended if \code{ergmito} was
not compiled with OpenMP (otherwise it will be slower).}

\item{cl}{An object of class \code{cluster} (see \code{\link[parallel:makeCluster]{makePSOCKcluster}})}
}
\value{
An object of class \code{ergmito_boot} and \link{ergmito}. This adds three
elements to the \code{ergmito} object:
\itemize{
\item \code{R} The number of replicates.
\item \code{sample} A vector of length \code{R} with the cases used in each replicate.
\item \code{dist} The distribution of fitted parameters.
\item \code{nvalid} the number of cases used for computing the covar.
\item \code{timer_boot} records the time the whole process took.
}
}
\description{
Bootstrap of ergmito
}
\details{
The resulting sample of parameters estimates is then used to compute
the variance-covariance matrix of the model. Cases in which \code{Inf}/\code{NaN}/\code{NA}
values were returned are excluded from the calculation.
}
\examples{

data(fivenets)
set.seed(123)
ans0 <- ergmito(fivenets ~ edges + ttriad)
ans1 <- suppressWarnings(ergmito_boot(ans0, R = 100))
ans2 <- suppressWarnings(ergmito_boot(fivenets ~ edges + ttriad, R = 100))

# Checking the differences
summary(ans0)
summary(ans1)
summary(ans2)
}
