% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/ModelSEIR.R
\name{ModelSEIR}
\alias{ModelSEIR}
\alias{epiworld_seir}
\title{Susceptible Exposed Infected Recovered model (SEIR)}
\usage{
ModelSEIR(name, prevalence, transmission_rate, incubation_days, recovery_rate)
}
\arguments{
\item{name}{String. Name of the virus.}

\item{prevalence}{Double. Initial proportion of individuals with the virus.}

\item{transmission_rate}{Numeric scalar between 0 and 1. Virus's rate of
infection.}

\item{incubation_days}{Numeric scalar greater than 0. Average number of
incubation days.}

\item{recovery_rate}{Numeric scalar between 0 and 1. Rate of recovery_rate from virus.}
}
\value{
\itemize{
\item The \code{ModelSEIR}function returns a model of class \link{epiworld_model}.
}
}
\description{
Susceptible Exposed Infected Recovered model (SEIR)
}
\details{
The \link{initial_states} function allows the user to set the initial state of the
model. The user must provide a vector of proportions indicating the following
values: (1) Proportion of non-infected agents who are removed, and (2)
Proportion of exposed agents to be set as infected.
}
\section{Model diagram}{

\figure{seir.png}{SEIR Diagram}
}

\examples{
model_seir <- ModelSEIR(name = "COVID-19", prevalence = 0.01,
  transmission_rate = 0.9, recovery_rate = 0.1, incubation_days = 4)

# Adding a small world population
agents_smallworld(
  model_seir,
  n = 1000,
  k = 5,
  d = FALSE,
  p = .01
)

# Running and printing
run(model_seir, ndays = 100, seed = 1912)
model_seir

plot(model_seir, main = "SEIR Model")
}
\seealso{
epiworld-methods

Other Models: 
\code{\link{ModelDiffNet}()},
\code{\link{ModelMeaslesMixing}()},
\code{\link{ModelMeaslesMixingRiskQuarantine}()},
\code{\link{ModelMeaslesSchool}()},
\code{\link{ModelSEIRCONN}()},
\code{\link{ModelSEIRD}()},
\code{\link{ModelSEIRDCONN}()},
\code{\link{ModelSEIRMixing}()},
\code{\link{ModelSEIRMixingQuarantine}()},
\code{\link{ModelSIR}()},
\code{\link{ModelSIRCONN}()},
\code{\link{ModelSIRD}()},
\code{\link{ModelSIRDCONN}()},
\code{\link{ModelSIRLogit}()},
\code{\link{ModelSIRMixing}()},
\code{\link{ModelSIS}()},
\code{\link{ModelSISD}()},
\code{\link{ModelSURV}()},
\code{\link{epiworld-data}}
}
\concept{Models}
\concept{general-models}
