% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/beta_div.r
\name{unweighted_unifrac}
\alias{unweighted_unifrac}
\title{Unweighted UniFrac}
\usage{
unweighted_unifrac(counts, tree = NULL, pairs = NULL, cpus = n_cpus())
}
\arguments{
\item{counts}{An OTU abundance matrix where each column is a sample, and
each row is an OTU. Any object coercible with \code{as.matrix()} can be
given here, as well as \code{phyloseq}, \code{rbiom}, \code{SummarizedExperiment},
and \code{TreeSummarizedExperiment} objects.}

\item{tree}{A \code{phylo}-class object representing the phylogenetic tree for
the OTUs in \code{counts}. The OTU identifiers given by \code{colnames(counts)}
must be present in \code{tree}. Can be omitted if a tree is embedded with
the \code{counts} object or as \code{attr(counts, 'tree')}.}

\item{pairs}{Which combinations of samples should distances be
calculated for? The default value (\code{NULL}) calculates all-vs-all.
Provide a numeric or logical vector specifying positions in the
distance matrix to calculate. See examples.}

\item{cpus}{How many parallel processing threads should be used. The
default, \code{n_cpus()}, will use all logical CPU cores.}
}
\value{
A \code{dist} object.
}
\description{
Unweighted UniFrac beta diversity metric.
}
\section{Calculation}{


Given \eqn{n} branches with lengths \eqn{L} and a pair of samples'
abundances (\eqn{A} and \eqn{B}) on each of those branches:

\deqn{D = \displaystyle \frac{\sum_{i = 1}^{n} L_i(|A_i - B_i|)}{\sum_{i = 1}^{n} L_i(max(A_i,B_i))}}

Abundances in \eqn{A} and \eqn{B} are coded as \code{1} or \code{0} to indicate their
presence or absence, respectively, on each branch.

See \url{https://cmmr.github.io/ecodive/articles/unifrac.html} for details and
a worked example.
}

\examples{
    # Example counts matrix
    ex_counts
    
    # Unweighted UniFrac distance matrix
    unweighted_unifrac(ex_counts, tree = ex_tree)
    
    # Only calculate distances for A vs all.
    unweighted_unifrac(ex_counts, tree = ex_tree, pairs = 1:3)
    
}
\references{
Lozupone C, Knight R 2005.
UniFrac: A new phylogenetic method for comparing microbial communities.
Applied and Environmental Microbiology, 71(12).
\doi{10.1128/AEM.71.12.8228-8235.2005}
}
\seealso{
Other beta_diversity: 
\code{\link{bray_curtis}()},
\code{\link{canberra}()},
\code{\link{euclidean}()},
\code{\link{generalized_unifrac}()},
\code{\link{gower}()},
\code{\link{jaccard}()},
\code{\link{kulczynski}()},
\code{\link{manhattan}()},
\code{\link{variance_adjusted_unifrac}()},
\code{\link{weighted_normalized_unifrac}()},
\code{\link{weighted_unifrac}()}
}
\concept{beta_diversity}
