% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/cord_s3.R
\name{plot.cord}
\alias{plot.cord}
\title{Plots an ordination of latent variables and their corresponding coefficients (biplot).}
\usage{
\method{plot}{cord}(
  x,
  biplot = FALSE,
  site.col = "black",
  sp.col = "blue",
  alpha = 0.7,
  arrow = TRUE,
  site.text = FALSE,
  labels = dimnames(x$obj$fitted),
  ...
)
}
\arguments{
\item{x}{is a cord object, e.g. from output of \code{cord}}

\item{biplot}{\code{TRUE} if both latent variables and their coefficients are plotted, \code{FALSE} if only latent variables}

\item{site.col}{site number colour (default is black), vector of length equal to the number of sites}

\item{sp.col}{species name colour (default is blue), vector of length equal to the number of sites (if arrow=TRUE)}

\item{alpha}{scaling factor for ratio of scores to loadings (default is 0.7)}

\item{arrow}{should arrows be plotted for species loadings (default is TRUE)}

\item{site.text}{should sites be labeled by row names of data (default is FALSE, points are drawn)}

\item{labels}{the labels for sites and species (for biplots only) (default is data labels)}

\item{...}{other parameters to be passed through to plotting functions.}
}
\value{
an ordination plot.
}
\description{
Plots an ordination of latent variables and their corresponding coefficients (biplot).
}
\examples{
X <- spider$x
abund <- spider$abund
spider_mod <- stackedsdm(abund,~1, data = X, ncores=2) 
spid_lv=cord(spider_mod)
#colour sites according to second column of x (bare sand)
cols=ifelse(spider$x[,2]>0,"black","red")
plot(spid_lv,biplot = FALSE,site.col=cols, site.text = TRUE)

\donttest{
library(ggplot2)
library(RColorBrewer)
alpha= 2.5
site_res <- data.frame(spid_lv$scores,X)
sp_res <- data.frame(spid_lv$loadings,species=colnames(abund))
ggplot()+
 geom_point(aes(x=Factor1,y=Factor2,color = reflection ),site_res)+
 geom_text(aes(x = Factor1*alpha, y = Factor2*alpha,label = species),data=sp_res)+
 scale_color_gradientn(colours = brewer.pal(n = 10, name = "PuOr"))+
 theme_classic()
}
}
