% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/RcppExports.R
\name{posterior}
\alias{posterior}
\title{Calculate posterior for one item given score, difficulty and prior}
\usage{
posterior(score, tau, prior, qp, scale)
}
\arguments{
\item{score}{Integer, either 0 (fail) and 1 (pass)}

\item{tau}{Numeric, difficulty parameter}

\item{prior}{Vector of prior values on quadrature points \code{qp}}

\item{qp}{vector of equally spaced quadrature points}

\item{scale}{expansion relative to the logit scale}
}
\value{
A vector of length \code{length(prior)}
}
\description{
Calculate posterior for one item given score, difficulty and prior
}
\details{
This function assumes that the difficulties have been estimated by
a binary Rasch model, e.g. by \code{rasch.pairwise.itemcluster()} of
the \code{sirt} package.
}
\note{
: Internal function
}
\seealso{
\code{\link[=dscore]{dscore()}}
}
\author{
Stef van Buuren, Arjan Huizing, 2020
}
