% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/plotMarkerAxis.r
\name{plotMarkerAxis}
\alias{plotMarkerAxis}
\title{Add a Marker Axis with Chromosome Names to a Plot of Polarized Genotypes}
\usage{
plotMarkerAxis(
  includedSites,
  ChosenSites = "all",
  tickDist = 1e+06,
  axisInfo = NULL,
  ...
)
}
\arguments{
\item{includedSites}{A character path to a file with columns \code{CHROM} and \code{POS}.}

\item{ChosenSites}{A logical vector indicating which sites are to be included in the
analysis.}

\item{tickDist}{A numeric indicating the spacing of physical tick marks along a chromosome.}

\item{axisInfo}{A list with user-defined tick positions and labels for marker axis. See
Details.}

\item{...}{additional arguments.}
}
\value{
Returns an invisible \code{axisInfo} list with the tick positions and labels
for the marker axis.
}
\description{
This function adds a marker axis with chromosome names to an existing plot of polarized
genotypes. It requires that the plot is already created using \link{plotPolarized}.
}
\details{
Either \code{axisInfo} or \code{includedSites} must be provided. If
\code{axisInfo = NULL}, the function extracts the necessary information from the
\code{includedSites} file. The \code{includedSites} file should ideally be generated by
\link{vcf2diem} to ensure congruence between the plotted genotypes and
the respective metadata.

Tick mark distances within a chromosome are spaced at intervals of \code{tickDist}
(in bp) and formatted to multiples of millions.

The positions in \code{axisInfo} (e.g., \code{ticksPos}, \code{CHROMbreaks},
\code{CHROMnamesPos}) are in units of marker index (i.e. column positions in the
genotype matrix used in the previous \code{plotPolarized} call).

The optional \code{axisInfo} argument must be a list with five named elements:
\itemize{
\item \code{CHROMbreaks}: Numeric vector of positions defining ticks that separate
chromosomes.
\item \code{CHROMnamesPos}: Numeric vector of label positions for chromosome names.
\item \code{CHROMnames}: Character vector of chromosome names (same length as
\code{CHROMnamesPos}).
\item \code{ticksPos}: Numeric vector with tick positions within chromosomes.
\item \code{ticksNames}: Character vector of labels corresponding to \code{ticksPos}.
Potentially overlapping labels are automatically replaced with \code{""}.
}

The \code{...} arguments accept additional graphical parameters passed to either
\code{axis()}, \code{mtext()}, or \code{circos.*()} functions, depending on plot type.
The following arguments are supported:

\strong{Rectangular axis arguments:} \code{side}, \code{col.ticks},
\code{labels}, \code{las}, \code{tick}, \code{line}, \code{tcl}, \code{cex},
\code{cex.axis}, \code{pos}, \code{outer}, \code{font}, \code{lty}, \code{lwd},
\code{lwd.ticks}, \code{hadj}, \code{padj}, \code{gap.axis}, \code{xpd}.

\strong{Circular axis arguments (used in iris/circular plots):}
\code{major.tick.length}, \code{lwd}, \code{labels.cex}, \code{cex}, \code{niceFacing},
\code{labels.niceFacing}, \code{facing}, \code{labels.facing}, \code{track.height},
\code{adj}.

In rectangular plots, chromosome names are drawn using \code{mtext()}, with size
scaled by \code{cex * 1.1}. Tick labels for positions use the same \code{cex}.

In circular plots (types \code{"iris"} or \code{"circular"}), tick positions and
chromosome names  are drawn using \code{circos.axis()} and \code{circos.text()},
respectively. Their sizes are controlled separately:
\itemize{
\item \code{labels.cex} controls the size of tick position numbers,
\item \code{cex} controls the size of chromosome name labels.
}

Similarly, text facing is controlled independently:
\itemize{
\item \code{labels.niceFacing} affects the tick labels,
\item \code{niceFacing} affects chromosome names.
}

The default alignment for chromosome names is set by \code{adj = c(1, 0.5)}, meaning
right-aligned and vertically centered.

To optimize the marker axis format in iris plots, it is recommended to test with only
one sample plotted to save processing time.
}
\examples{
\dontrun{
# Run this example in a working directory with write permissions
myo <- system.file("extdata", "myotis.vcf", package = "diemr")
vcf2diem(myo, "myo")
inds <- 1:14
fit <- diem("myo-001.txt", ChosenInds = inds, ploidy = FALSE)
gen <- importPolarized("myo-001.txt", fit$markerPolarity, inds)
h <- apply(gen, 1, function(x) pHetErrOnStateCount(sStateCount(x)))[1, ]
plotPolarized(gen, h, xlab = "")
plotMarkerAxis("myo-includedSites.txt", tickDist = 100)

plotPolarized(gen, h, type = "iris")
plotMarkerAxis("myo-includedSites.txt", tickDist = 100)
}
}
\seealso{
\code{\link{plotPolarized}} to generate the base plot.
}
