% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/devRate_pheno.R
\name{devRateIBMgen}
\alias{devRateIBMgen}
\title{Number of generations}
\usage{
devRateIBMgen(ibm)
}
\arguments{
\item{ibm}{The phenology model returned by devRateIBM function.}
}
\value{
The simulated number of generations.
}
\description{
Computes the number of generations from the individual-based model fit.
}
\examples{
data(exTropicalMoth)
forecastTsolanivora <- devRateIBM(
   tempTS = rnorm(n = 100, mean = 15, sd = 1),
   timeStepTS = 1,
   models = exTropicalMoth[[2]],
   numInd = 10,
   stocha = 0.015,
   timeLayEggs = 1)
devRateIBMgen(ibm = forecastTsolanivora)
}
