% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/data-idahohd2.r
\docType{data}
\name{idahohd2}
\alias{idahohd2}
\title{Altura-diámetro de árboles en el estado de Idaho (USA)}
\format{
Contiene cinco variables detalladas a continuación:
\describe{
\item{parce}{Número de la parcela de muestreo.}
\item{arbol}{Número del árbol dentro de la parcela.}
\item{spp}{Especie del árbol. Una variable factor con los siguientes
niveles: "DF" es Douglas-fir (\emph{Pseudotsuga menziesii}),
"GF" es Grand fir (\emph{Abies grandis}),
"SF" es Subalpine fir (\emph{Abies lasiocarpa}),
"WL" es Western larch (\emph{Larix occidentalis}),
"WC" es Western red cedar (\emph{Thuja plicata}), y
"WP" es White pine (\emph{Pinus strobus}).}
\item{dap}{Diámetro del fuste a los 1.3 m sobre el suelo, en cm.}
\item{atot}{Altura total  del árbol, en m.}
}
}
\source{
Los datos fueron obtenidos desde la dataframe \code{ufc} de la librería \code{alr4}.
}
\usage{
data(idahohd2)
}
\description{
Estos datos provienen de un muestreo en el bosque experimental de la
University of Idaho, en Upper Flat Creek, Idaho, USA. Medido en 1991.
}
\examples{
data(idahohd2)    
head(idahohd2)
plot(atot~dap, data=idahohd2)
}
\references{
Weisberg S. 2014. Applied Linear Regression. 4th edition. New York: Wiley.
}
\keyword{datasets}
