% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/api.R
\name{po_scatter}
\alias{po_scatter}
\title{Scatter}
\usage{
po_scatter(d3po, ..., data = NULL, inherit_daes = TRUE)
}
\arguments{
\item{d3po}{Either the output of \code{\link[=d3po]{d3po()}} or \code{\link[=d3po_proxy]{d3po_proxy()}}.}

\item{...}{Aesthetics, see \code{\link[=daes]{daes()}}.}

\item{data}{Any dataset to use for plot, overrides data passed
to \code{\link[=d3po]{d3po()}}.}

\item{inherit_daes}{Whether to inherit aesthetics previous specified.}
}
\value{
an 'htmlwidgets' object with the desired interactive plot
}
\description{
Plot an scatter chart.
}
\examples{
if (interactive()) {
  # Create a wide dataset with x = 2019 and y = 2023 trade values
  trade_wide_2019 <- d3po::trade[d3po::trade$year == 2019L, c("reporter", "trade")]
  trade_wide_2019 <- aggregate(trade ~ reporter, data = trade_wide_2019, FUN = sum)

  trade_wide_2023 <- d3po::trade[d3po::trade$year == 2023L, c("reporter", "trade")]
  trade_wide_2023 <- aggregate(trade ~ reporter, data = trade_wide_2023, FUN = sum)

  trade_wide <- merge(
    trade_wide_2019,
    trade_wide_2023,
    by = "reporter",
    suffixes = c("_2019", "_2023")
  )

  my_pal <- tintin::tintin_pal(option = "red_rackhams_treasure")(7)

  d3po(trade_wide, width = 800, height = 600) \%>\%
    po_scatter(daes(x = trade_2019, y = trade_2023, group = reporter, color = my_pal)) \%>\%
    po_labels(
      x = "Trade in 2019 (USD billion)",
      y = "Trade in 2023 (USD billion)",
      title = "Trade Volume by Country in 2019 and 2023"
    )
}
}
