% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/api.R
\name{po_box}
\alias{po_box}
\title{Boxplot}
\usage{
po_box(d3po, ..., data = NULL, inherit_daes = TRUE)
}
\arguments{
\item{d3po}{Either the output of \code{\link[=d3po]{d3po()}} or \code{\link[=d3po_proxy]{d3po_proxy()}}.}

\item{...}{Aesthetics, see \code{\link[=daes]{daes()}}.}

\item{data}{Any dataset to use for plot, overrides data passed
to \code{\link[=d3po]{d3po()}}.}

\item{inherit_daes}{Whether to inherit aesthetics previous specified.}
}
\value{
an 'htmlwidgets' object with the desired interactive plot
}
\description{
Draw a boxplot.
}
\examples{
if (interactive()) {
  trade_continent <- d3po::trade
  trade_continent <- aggregate(
    trade ~ reporter_continent + reporter,
    data = trade_continent,
    FUN = sum
  )

  my_pal <- tintin::tintin_pal(option = "Destination Moon")(7)

  names(my_pal) <- c(
    "Africa", "Antarctica", "Asia",
    "Europe", "North America", "Oceania", "South America"
  )

  d3po(trade_continent, width = 800, height = 600) \%>\%
    po_box(daes(
      x = reporter_continent, y = trade, color = my_pal,
      tooltip = reporter_continent
    )) \%>\%
    po_labels(
      x = "Continent",
      y = "Trade (USD billion)",
      title = "Trade Distribution by Reporter Continent"
    )
}
}
