% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/chemical-APIs-batch.R
\name{get_msready_by_dtxcid_batch}
\alias{get_msready_by_dtxcid_batch}
\title{Get msready by DTXCID batch search}
\usage{
get_msready_by_dtxcid_batch(
  DTXCID = NULL,
  API_key = NULL,
  rate_limit = 0L,
  verbose = FALSE
)
}
\arguments{
\item{DTXCID}{A list of chemical identifier DTXCIDs}

\item{API_key}{A user-specific API key}

\item{rate_limit}{Number of seconds to wait between each request}

\item{verbose}{A logical indicating if some “progress report” should be given.}
}
\value{
A named list of character lists of DTXSIDs with DTXCIDs matching the
search criteria
}
\description{
Get msready by DTXCID batch search
}
\examples{
\dontshow{if (has_ctx_key() & is.na(ctx_key() == 'FAKE_KEY')) (if (getRversion() >= "3.4") withAutoprint else force)(\{ # examplesIf}
# Pull msready chemicals matching specific DTXCID
dtxcid_msready <- get_msready_by_dtxcid_batch(DTXCID = c('DTXCID30182',
                                                         'DTXCID001315'))
\dontshow{\}) # examplesIf}
}
