#' Continuous-time multivariate analysis
#'
#' Implements continuous-time analogues of several classical techniques of multivariate analysis.
#' The inputs are \code{"\link[fda]{fd}"} (functional data) objects from the \pkg{fda} package.
#'
#' @name ctmva-package
#' @aliases ctmva-package ctmva
#' @docType package
#'
#' @author Biplab Paul <paul.biplab497@gmail.com> and Philip Tzvi Reiss <reiss@stat.haifa.ac.il>
#'
#' @references Paul, B., Reiss, P. T. and Cui, E. (2023). Continuous-time multivariate analysis. arXiv:2307.09404 [stat.ME]
#' @keywords package
#'
#' @importFrom fda fd eval.basis eval.fd
#' @importFrom graphics abline legend matplot mtext
#' @importFrom stats as.formula lm runif

NULL



