% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/Samples-methods.R
\name{plot,Samples,Model-method}
\alias{plot,Samples,Model-method}
\title{Plotting dose-toxicity model fits}
\usage{
\S4method{plot}{Samples,Model}(
  x,
  y,
  data,
  ...,
  xlab = "Dose level",
  ylab = "Probability of DLT [\%]",
  showLegend = TRUE
)
}
\arguments{
\item{x}{the \code{\linkS4class{Samples}} object}

\item{y}{the \code{\linkS4class{Model}} object}

\item{data}{the \code{\linkS4class{Data}} object}

\item{\dots}{not used}

\item{xlab}{the x axis label}

\item{ylab}{the y axis label}

\item{showLegend}{should the legend be shown? (default)}
}
\value{
This returns the \code{\link[ggplot2]{ggplot}}
object for the dose-toxicity model fit
}
\description{
Plotting dose-toxicity model fits
}
\examples{

# Create some data
data <- Data(x = c(0.1, 0.5, 1.5, 3, 6, 10, 10, 10),
             y = c(0, 0, 0, 0, 0, 0, 1, 0),
             cohort = c(0, 1, 2, 3, 4, 5, 5, 5),
             doseGrid = c(0.1, 0.5, 1.5, 3, 6,
                          seq(from = 10, to = 80, by=2)))

# Initialize a model 
model <- LogisticLogNormal(mean = c(-0.85, 1),
                           cov = matrix(c(1, -0.5, -0.5, 1), nrow = 2),
                           refDose = 56)

# Get posterior for all model parameters
options <- McmcOptions(burnin = 100,
                       step = 2,
                       samples = 2000)
set.seed(94)
samples <- mcmc(data, model, options)

# Plot the posterior mean  (and empirical 2.5 and 97.5 percentile)
# for the prob(DLT) by doses
plot(x = samples, y = model, data = data)
              



}
