% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/Simulations-class.R
\docType{class}
\name{GeneralSimulationsSummary-class}
\alias{GeneralSimulationsSummary-class}
\alias{.GeneralSimulationsSummary}
\title{Class for the summary of general simulations output}
\description{
Note that objects should not be created by users, therefore no
initialization function is provided for this class.
}
\section{Slots}{

\describe{
\item{\code{target}}{target toxicity interval}

\item{\code{targetDoseInterval}}{corresponding target dose interval}

\item{\code{nsim}}{number of simulations}

\item{\code{propDLTs}}{proportions of DLTs in the trials}

\item{\code{meanToxRisk}}{mean toxicity risks for the patients}

\item{\code{doseSelected}}{doses selected as MTD}

\item{\code{toxAtDosesSelected}}{true toxicity at doses selected}

\item{\code{propAtTarget}}{Proportion of trials selecting target MTD}

\item{\code{doseMostSelected}}{dose most often selected as MTD}

\item{\code{obsToxRateAtDoseMostSelected}}{observed toxicity rate at dose most often
selected}

\item{\code{nObs}}{number of patients overall}

\item{\code{nAboveTarget}}{number of patients treated above target tox interval}

\item{\code{doseGrid}}{the dose grid that has been used}

\item{\code{placebo}}{set to TRUE (default is FALSE) for a design with placebo}
}}

\keyword{classes}
