% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/rename.R
\name{rename}
\alias{rename}
\alias{ref_rename}
\alias{rename.Container}
\alias{rename.dict.table}
\alias{ref_rename.dict.table}
\alias{rename.default}
\title{Rename Elements Safely}
\usage{
rename(.x, old, new)

ref_rename(.x, old, new)

\method{rename}{Container}(.x, old, new)

\method{rename}{dict.table}(.x, old, new)

\method{ref_rename}{dict.table}(.x, old, new)

\method{rename}{default}(.x, old, new)
}
\arguments{
\item{.x}{\code{dict.table} object}

\item{old}{\code{character} old name}

\item{new}{\code{character} new name}
}
\value{
For standard \code{R} vectors renames \code{old} to \code{new} and returns the
renamed vector.

For \code{Container}, an object of class \code{Container} (or one of the
respective derived classes).

For \code{dict.table} renames key \code{old} to \code{new} in place (i.e. by
reference) and invisibly returns the \code{\link[=dict.table]{dict.table()}} object.
}
\description{
Search for old name and replace it by new name. If either the
old name does not exist or the name would result in a name-clash with an
already existing name, an error is signaled.
}
\details{
The passed old and new names can be vectors but always must have
the same length and must be unique to prevent double-renaming.

\code{rename} uses copy semantics while \code{ref_rename} works by reference,
that is, it renames elements in place.
}
\examples{

# Container
co = container(a = 1, b = 2, 3)
rename(co, c("a", "b"), c("a1", "y"))
print(co)
ref_rename(co, c("a", "b"), c("a1", "y"))
print(co)

# dict.table
dit = dict.table(a = 1, b = 2, c = 3)
rename(dit, c("a", "b"), c("a1", "y"))
print(dit)
ref_rename(dit, c("a", "b"), c("a1", "y"))
print(dit)
}
