% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/cifmodeling-package.R
\docType{package}
\name{cifmodeling-package}
\alias{cifmodeling}
\alias{cifmodeling-package}
\title{cifmodeling: Visualization and Polytomous Modeling of Survival and Competing Risks}
\description{
A publication-ready toolkit for modern survival and competing risks analysis with a minimal, formula-based interface. Both nonparametric estimation and direct polytomous regression of cumulative incidence functions (CIFs) are supported. The main functions 'cifcurve()', 'cifplot()', and 'cifpanel()' estimate survival and CIF curves and produce high-quality graphics with risk tables, censoring and competing-event marks, and multi-panel or inset layouts built on 'ggplot2' and 'ggsurvfit'. The modeling function 'polyreg()' performs direct polytomous regression for coherent joint modeling of all cause-specific CIFs to estimate risk ratios, odds ratios, or subdistribution hazard ratios at user-specified time points. All core functions adopt a formula-and-data syntax and return tidy and extensible outputs that integrate smoothly with 'modelsummary', 'broom', and the broader 'tidyverse' ecosystem. Key numerical routines are implemented in C++ via 'Rcpp'.
}
\seealso{
Useful links:
\itemize{
  \item \url{https://gestimation.github.io/cifmodeling/}
  \item \url{https://github.com/gestimation/cifmodeling}
  \item Report bugs at \url{https://github.com/gestimation/cifmodeling/issues}
}

}
\author{
\strong{Maintainer}: Shiro Tanaka \email{gestimation@gmail.com} (\href{https://orcid.org/0000-0001-6817-5235}{ORCID}) [copyright holder]

Other contributors:
\itemize{
  \item Shigetaka Kobari [contributor]
  \item Chisato Honda [contributor]
}

}
\keyword{internal}
