% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/RcppExports.R
\name{random_population}
\alias{random_population}
\title{Random population initialization}
\usage{
random_population(popsize, prange, N, minDist, Pb, mmax, lmax)
}
\arguments{
\item{popsize}{An integer represents the number of individual in each
population for GA (or subpopulation for IslandGA).}

\item{prange}{Default is \code{NULL} for only changepoint detection. If
\code{prange} is specified as a list object, which contains the range of
each model order parameters for order selection (integers). The number of
order parameters must be equal to the length of \code{prange}.}

\item{N}{The length of time series.}

\item{minDist}{The minimum length between two adjacent changepoints.}

\item{Pb}{Same as \code{Pchangepoint}, the probability that a changepoint has occurred.}

\item{mmax}{The maximum possible number of changepoints in the data set.}

\item{lmax}{The maximum possible length of the chromosome representation.}
}
\value{
A matrix that contains each individual's chromosome.
}
\description{
Randomly generate the individuals' chromosomes (changepoint confirgurations)
to construct the first generation population.
}
\details{
The default population initialization uses \code{\link{selectTau}} to
select the chromosome for the first generation population. Each column from
the produced population matrix represent an chromosome of an individual.
The first element of every chromosome represent the number of changepoints
and the last non-zero element always equal to the length of time series
plus one (N+1).
}
