% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/QCplotFuns.R
\name{qc_violin_plot}
\alias{qc_violin_plot}
\title{Create a violin/box plot of expression across samples of an experiment}
\usage{
qc_violin_plot(
  expression.matrix,
  metadata,
  annotation.id,
  log.transformation = TRUE
)
}
\arguments{
\item{expression.matrix}{the expression matrix; rows correspond to genes and
columns correspond to samples; usually preprocessed by
\code{\link{preprocessExpressionMatrix}}; a list  (of the same length as
modality) can be provided if #' \code{length(modality) > 1}}

\item{metadata}{a data frame containing metadata for the samples contained
in the expression.matrix; must contain at minimum two columns:
the first column must contain the column names of the expression.matrix,
while the last column is assumed to contain the experimental conditions
that will be tested for differential expression; a list  (of the same
length as modality) can be provided if #' \code{length(modality) > 1}}

\item{annotation.id}{name of metadata column on which to group samples}

\item{log.transformation}{whether expression should be shown on log (default) or
linear scale}
}
\value{
The violin/box plot as a ggplot object.
}
\description{
This function creates a combined violin and box plot between
all samples in the expression matrix. Metadata columns are used to colour samples.
}
\examples{
expression.matrix.preproc <- as.matrix(read.csv(
  system.file("extdata", "expression_matrix_preprocessed.csv", package = "bulkAnalyseR"), 
  row.names = 1
))[1:500,]

metadata <- data.frame(
  srr = colnames(expression.matrix.preproc), 
  timepoint = rep(c("0h", "12h", "36h"), each = 2)
)
print(qc_violin_plot(expression.matrix.preproc, metadata, 'timepoint'))

}
