% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/bandit.R
\name{banditize}
\alias{banditize}
\title{Create a multi-armed Bayesian bandit object.}
\usage{
banditize(bT, param, higher_is_better = TRUE)
}
\arguments{
\item{bT}{a bayesTest object}

\item{param}{which model parameter (posterior) to evaluate; defaults to first param}

\item{higher_is_better}{is a higher value of `param` equivalent to a better choice?}
}
\value{
A bayesBandit object.
}
\description{
Fit a multi-armed bandit object based on a bayesTest which can serve recommendations and adapt
to new data.
}
\details{
\code{banditize} is an 'object-oriented' implementation of multi-armed bandits in \code{bayesAB}. It is useful in
conjunction with a Shiny app or Plumber deployment. The object itself is mutable and can adapt/learn from new data without having to
re-assign the variable.

Comes with 5 methods:

\itemize{
 \item \code{serveRecipe()}: serves a recipe to show your user based on samples from both posteriors.
 \item \code{setResults(results)}: set results for one or more recipes for one or more instances of feedback. Used to update bandit.
 \item \code{getBayesTest()}: returns most updated \code{bayesTest} object.
 \item \code{getOriginalTest()}: returns original \code{bayesTest} object without any updates.
 \item \code{getUpdates()}: returns a summarized version of all updates this bandit has processed.}
}
\examples{
A_binom <- rbinom(100, 1, .5)
B_binom <- rbinom(100, 1, .6)

AB1 <- bayesTest(A_binom, B_binom, priors = c('alpha' = 1, 'beta' = 1), distribution = 'bernoulli')

binomialBandit <- banditize(AB1)
binomialBandit$serveRecipe()
binomialBandit$setResults(list('A' = c(1, 0, 1, 0, 0), 'B' = c(0, 0, 0, 0, 1)))

}
