% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/createClusterST.R
\name{createClusterST}
\alias{createClusterST}
\title{Create a short-term storage cluster}
\usage{
createClusterST(
  area,
  cluster_name,
  group = "Other1",
  storage_parameters = storage_values_default(),
  PMAX_injection = NULL,
  PMAX_withdrawal = NULL,
  inflows = NULL,
  lower_rule_curve = NULL,
  upper_rule_curve = NULL,
  add_prefix = TRUE,
  overwrite = FALSE,
  opts = antaresRead::simOptions()
)
}
\arguments{
\item{area}{The area where to create the cluster.}

\item{cluster_name}{Name for the cluster, it will prefixed by area name, unless you set \code{add_prefix = FALSE}.}

\item{group}{Group of the cluster, one of : "PSP_open", "PSP_closed", "Pondage", "Battery", "Other".
It corresponds to the type of stockage.}

\item{storage_parameters}{\code{list } Parameters to write in the Ini file (see \code{Note}).}

\item{PMAX_injection}{Modulation of charging capacity on an 8760-hour basis. \code{numeric} \{0;1\} (8760*1).}

\item{PMAX_withdrawal}{Modulation of discharging capacity on an 8760-hour basis. \code{numeric} \{0;1\} (8760*1).}

\item{inflows}{Algebraic deviation of the state of charge of the storage, which does not induce any power
generation or consumption on the system \code{numeric} \{<0;>0\} (8760*1).}

\item{lower_rule_curve}{This is the lower limit for filling the stock imposed each hour. \code{numeric} \{0;1\} (8760*1).}

\item{upper_rule_curve}{This is the upper limit for filling the stock imposed each hour. \code{numeric} \{0;1\} (8760*1).}

\item{add_prefix}{If \code{TRUE} (the default), \code{cluster_name} will be prefixed by area name.}

\item{overwrite}{Logical, overwrite the cluster or not.}

\item{opts}{List of simulation parameters returned by the function
\code{\link[antaresRead:setSimulationPath]{antaresRead::setSimulationPath()}}}
}
\value{
An updated list containing various information about the simulation.
}
\description{
\ifelse{html}{\figure{badge_api_ok.svg}{options: alt='Antares API OK'}}{Antares API: \strong{OK}}

Create a new ST-storage cluster for >= v8.6.0 Antares studies.
}
\note{
To write parameters to the \code{list.ini} file. You have function \code{storage_values_default()} who is called by default.
This function return \code{list} containing properties according study version for cluster \code{st-storage}.

Study version >= "8.6.0" :
\itemize{
\item efficiency = 1  (\code{numeric} \{0;1\})
\item reservoircapacity = 0  (\code{integer} >= 0)
\item initiallevel = 0  (\code{numeric} \{0;1\})
\item withdrawalnominalcapacity = 0  (\code{integer} >= 0)
\item injectionnominalcapacity = 0  (\code{integer} >= 0)
\item initialleveloptim = FALSE (\code{logical} TRUE/FALSE)
}

Study version >= "8.8.0" (update + new parameter) :
\itemize{
\item initiallevel = 0.5  (\code{numeric} \{0;1\})
\item enabled = TRUE (\code{logical} TRUE/FALSE)
}

By default, these values don't allow you to have an active cluster (See example section.)
}
\examples{
\dontrun{

# list for cluster parameters : 
storage_values_default()

# create a cluster by default (with default parameters values + default data values):
createClusterST(area = "my_area", 
               "my_cluster") 
  
# Read cluster in study                            
 # by default, cluster name is prefixed 
 # by the area name
levels(readClusterSTDesc()$cluster)
# > "my_area_my_cluster"

# create cluster with custom parameter and data
  # use the function to create your own list of parameters (no Antares optim)
  # if you want optim (my_parameters$initialleveloptim <- TRUE)
my_parameters <- storage_values_default()
my_parameters$efficiency <- 0.5
my_parameters$initiallevel <- 10
my_parameters$withdrawalnominalcapacity <- 100
my_parameters$injectionnominalcapacity <- 1000
my_parameters$reservoircapacity <- 10000

  # time series 
inflow_data <- matrix(3, 8760)
ratio_data <- matrix(0.7, 8760)

createClusterST(area = "my_area", 
                "my_cluster",
                storage_parameters = my_parameters,
                PMAX_withdrawal = ratio_data, 
                inflows = inflow_data, 
                PMAX_injection = ratio_data, 
                lower_rule_curve = ratio_data, 
                upper_rule_curve = ratio_data)
}

}
\seealso{
All the functions needed to manage a storage cluster,
\code{\link[antaresRead:readClusterDesc]{antaresRead::readClusterSTDesc()}}, \code{\link[=editClusterST]{editClusterST()}}, \code{\link[=removeClusterST]{removeClusterST()}}.
}
