% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/importSpectra.R
\name{importSpectra}
\alias{importSpectra}
\title{importSpectra}
\usage{
importSpectra(path, sep = ";")
}
\arguments{
\item{path}{A character vector with the full path to the data directory; by
default corresponds to the working directory, \code{\link{getwd}}.}

\item{sep}{The field separator character; by default sep = ";".}
}
\value{
A data frame with the structure:
\itemize{
 \item \emph{First column (WN)}: wave numbers of the spectra.
 \item \emph{1-n}: samples spectra (the column names correspond to the files
 names).
}
}
\description{
In case you have your spectra in separated files (.csv) this
  function imports and binds them in a single data frame. The files directory
  must contain only the samples files.
}
\examples{
# Create an empty directory
# Now create some spectra separate files
A <- andurinhaData[, 1:2]
B <- andurinhaData[, c(1, 3)]
C <- andurinhaData[, c(1, 4)]

MASS::write.matrix(A, file = tempfile(pattern = "A.csv"), sep = ";")
MASS::write.matrix(A, file = tempfile(pattern = "B.csv"), sep = ";")
MASS::write.matrix(A, file = tempfile(pattern = "C.csv"), sep = ";")

# Try
importSpectra(path = paste0(tempdir(), "/"), ";")

}
\seealso{
\code{\link{findPeaks}}, \code{\link{gOverview}} and
  \code{\link{plotPeaks}}
}
