% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/amf_plot_datasummary.R
\name{amf_plot_datasummary}
\alias{amf_plot_datasummary}
\title{Plot data summary}
\usage{
amf_plot_datasummary(
  data_sum = NULL,
  site_set = NULL,
  var_set = NULL,
  nonfilled_only = TRUE,
  show_cluster = FALSE,
  scale = FALSE
)
}
\arguments{
\item{data_sum}{A data frame with following columns:
\itemize{
  \item Site_ID - Six character site identifier (CC-Sss)
  \item VARIABLE - Variable name of the data included in the BASE file
  \item BASENAME - Variable base name of the data included in the BASE file.
  \item GAP_FILLED - Whether a variable is a gap-filled variable (TRUE/FALSE)
  \item Any statistics, e.g., P01, P05... output from
  \code{\link{amf_summarize_data}}
 }
 If not specified, use \code{\link{amf_summarize_data}} by default.}

\item{site_set}{A scalar or vector of character specifying the target
AmeriFlux Site ID (CC-Sss). If not specified, it returns all sites.}

\item{var_set}{A scalar or vector of character specifying the target
variables as in basename. See AmeriFlux
page\url{https://ameriflux.lbl.gov/data/aboutdata/data-variables/#base}
for a list of variable names. If not specified, it returns all variables.}

\item{nonfilled_only}{Logical, whether only showing non-filled variables,
or both non- and gap-filled variables. The default is TRUE.}

\item{show_cluster}{Logical, whether showing clustering (dendrogram) of
site-variables. The default is FALSE.}

\item{scale}{Logical, whether the values should be centered and scaled
among site-variables. The default is FALSE.}
}
\value{
An object of class 'plotly' from \code{\link[heatmaply]{heatmaply}}
}
\description{
This function visualizes the BASE data summary for
selected AmeriFlux sites and variables. This is a wrapper around
\code{\link{amf_summarize_data}}. However, it is strongly advised to
subset either sites or variables for faster processing and better
visualization.
}
\examples{
\dontrun{
# plot data summary for selected variables at two sites
amf_plot_datasummary(site_set = c("US-CRT", "US-WPT"),
                     var_set = c("H", "LE", "NETRAD"))

# plot data summary for FCH4 at all sites, and show
#  clustering among sites
amf_plot_datasummary(var_set = "FCH4",
                     show_cluster = TRUE)

# plot data summary for TA at all grassland sites,
#  and show clustering among sites
sites <- amf_site_info()
sites <- subset(sites, IGBP == "CRO")
amf_plot_datasummary(site_set = sites$SITE_ID,
                     var_set = "TA",
                     show_cluster = TRUE)

# normalize TA among sites
amf_plot_datasummary(site_set = sites$SITE_ID,
                     var_set = "TA",
                     show_cluster = TRUE,
                     scale = TRUE)
}
}
\seealso{
\code{\link{amf_summarize_data}}, \code{\link[heatmaply]{heatmaply}}
}
