% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/GISfuncs.R
\name{ConvertGridRef}
\alias{ConvertGridRef}
\title{Convert between British National Grid Reference (BNG) and Latitude and Longitude or Irish Grid references.}
\usage{
ConvertGridRef(x, fromBNG = TRUE, IGorLatLon = "LatLon")
}
\arguments{
\item{x}{A vector of length 2. Either latitude and longitude (if fromBNG = FALSE) or BNG easting and northing (if fromBNG = TRUE). Or Irish easting and northing if IGorLatLon is set to IG and fromBNG = FALSE.}

\item{fromBNG}{A logical argument with a default of TRUE. When TRUE it converts from BNG easting and northing to latitude and longitude (or to IG easting and northing if IGorLatLon is set to "IG"). When FALSE it converts the other way round.}

\item{IGorLatLon}{This argument allows you to choose between Latitude & Longitude and Irish grid reference. The acceptable options are "LatLon" or "IG". If you choose "IG" you are converting between BNG and IG. If you choose "LatLon", you are converting between BNG and Lat Lon.}
}
\value{
A data.frame with the converted grid references. Either latitude and longitude if BNG = TRUE. Or BNG easting and northing if fromBNG = FALSE. Or, IG easting & northing if fromBNG = TRUE and IGorLatLon = "IG".
}
\description{
Function to convert between BNG easting & northing and Latitude & Longitude (or vice versa). Or to convert between BNG and Irish national grid (or vice versa)
}
\details{
To convert to Lat and Lon from BNG, ensure that the fromBNG argument is TRUE. To convert the other way, set fromBNG as FALSE. The same applies for converting between Irish grid and BNG. To convert Irish grid and BNG set the IGorLatLon argument to IG.
}
\examples{
#Get Latitude and Longitude for a BNG numeric reference.
ConvertGridRef(c(462899, 187850))
#Now we'll get easting and northing as a function of latitude and longitude
ConvertGridRef(c(51.6, -1), fromBNG = FALSE)
}
\author{
Anthony Hammond
}
