% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/CorrelatedPfsAndOs4.R
\name{CorrelatedPfsAndOs4}
\alias{CorrelatedPfsAndOs4}
\title{Generate PFS, OS and objective response using the four-states model}
\usage{
CorrelatedPfsAndOs4(
  n,
  transition_probability,
  duration,
  death_name = "death",
  progression_name = "progression",
  response_name = "response"
)
}
\arguments{
\item{n}{integer. Number of observations.}

\item{transition_probability}{a 4x4 matrix defining transition probabilities
between stable (initial state, 1), response (2), progression (3) and
death (absorbing, 4).}

\item{duration}{integer. Duration of trial. Set it to a sufficient large
integer in practice to cover the duration of the trial (potentially be
extended).}

\item{death_name}{column name of OS in returned data frame. It must be
consistent with `name` in the function `endpoint()`.}

\item{progression_name}{column name of PFS in returned data frame. It must be
consistent with `name` in the function `endpoint()`.}

\item{response_name}{column name of objective response in returned data frame. It must be
consistent with `name` in the function `endpoint()`.}
}
\value{
A data frame of \code{n} rows and 6 columns (response, progression,
death, and their event indicators response_event, progression_event,
death_event with 1 means event and 0 means censored at duration).
}
\description{
Generate PFS, OS and objective response using the four-states model
}
\examples{
m <- matrix(c(0.99, 0.0035, 0.0055, 0.0010,
                 0, 0.9900, 0.0052, 0.0048,
                 0,      0, 0.9960, 0.0040,
                 0,      0,      0,      1),
             nrow = 4, byrow = TRUE)

pfs_and_os <- CorrelatedPfsAndOs4(1e4, m, 365 * 3)

}
