% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/LongBranchScore.R
\name{LongBranch}
\alias{LongBranch}
\title{Identify taxa with long branches}
\usage{
LongBranch(tree)
}
\arguments{
\item{tree}{A tree of class \code{\link[ape:read.tree]{phylo}}, or a list of trees
of class \code{list} or \code{multiPhylo}.}
}
\value{
\code{LongBranch()} returns a vector giving the long branch score for
each leaf in \code{tree}, or a list of such vectors if \code{tree} is a list.
Results are given as raw deviations, without multiplying by 100 as proposed
by \insertCite{Struck2014;textual}{TreeTools}.
}
\description{
The long branch (\acronym{LB}) score \insertCite{Struck2014}{TreeTools}
measures the deviation of the average pairwise patristic distance of a leaf
from all other leaves in a tree, relative to the average leaf-to-leaf
distance.
}
\details{
\insertCite{Struck2014;textual}{TreeTools} proposes the standard deviation
of LB scores as a measure of heterogeneity that can be compared between
trees; and the upper quartile of LB scores as "a representative value for
the taxa with the longest branches".
}
\examples{
tree <- BalancedTree(8, lengths = c(rep(2, 4), 5:7, rep(2, 4), rep(1, 3)))
lb <- LongBranch(tree)
tree$tip.label <- paste(tree$tip.label, signif(lb, 3), sep = ": ")
plot(tree, tip.col = SupportColour((1 - lb) / 2), font = 2)

# Standard deviation of LB scores allows comparison with other trees
sd(lb)
evenLengths <- BalancedTree(8, lengths = jitter(rep(1, 14)))
sd(LongBranch(evenLengths))

# Upper quartile identifies taxa with longest branches
threshold <- quantile(lb, 0.75)
tree$tip.label[lb > threshold]
}
\seealso{
Other tree properties: 
\code{\link{ConsensusWithout}()},
\code{\link{MatchEdges}()},
\code{\link{NSplits}()},
\code{\link{NTip}()},
\code{\link{NodeNumbers}()},
\code{\link{PathLengths}()},
\code{\link{SplitsInBinaryTree}()},
\code{\link{TipLabels}()},
\code{\link{TreeIsRooted}()},
\code{\link{Treeness}()}
}
\author{
\href{https://orcid.org/0000-0001-5660-1727}{Martin R. Smith}
(\href{mailto:martin.smith@durham.ac.uk}{martin.smith@durham.ac.uk})
}
\concept{tree properties}
