% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/phylo.R
\name{ListAncestors}
\alias{ListAncestors}
\alias{AllAncestors}
\title{List ancestors}
\usage{
ListAncestors(parent, child, node = NULL)

AllAncestors(parent, child)
}
\arguments{
\item{parent}{Integer vector corresponding to the first column of the edge
matrix of a tree of class \code{\link[ape]{phylo}}, i.e.
\code{tree[["edge"]][, 1]}}

\item{child}{Integer vector corresponding to the second column of the edge
matrix of a tree of class \code{\link[ape]{phylo}}, i.e.
\code{tree[["edge"]][, 2]}.}

\item{node}{Integer giving the index of the node or tip whose ancestors are
required, or \code{NULL} to return ancestors of all nodes.}
}
\value{
If \code{node = NULL}, \code{ListAncestors()} returns a list. Each entry \emph{i} contains
a vector containing, in order, the nodes encountered when traversing the tree
from node \emph{i} to the root node.
The last entry of each member of the list is therefore the root node,
with the exception of the entry for the root node itself, which is a
zero-length integer.

If \code{node} is an integer, \code{ListAncestors()} returns a vector of the numbers of
the nodes ancestral to the given \code{node}, including the root node.
}
\description{
\code{ListAncestors()} reports all ancestors of a given node.
}
\details{
Note that if \code{node = NULL}, the tree's edges must be listed such that each
internal node (except the root) is listed as a child before it is listed
as a parent, i.e. its index in \code{child} is less than its index in \code{parent}.
This will be true of trees listed in \link{Preorder}.
}
\section{Functions}{
\itemize{
\item \code{AllAncestors()}: Alias for \code{ListAncestors(node = NULL)}.

}}
\examples{
tree <- PectinateTree(5)
edge <- tree[["edge"]]

# Identify desired node with:
plot(tree)
nodelabels()
tiplabels()

# Ancestors of specific nodes:
ListAncestors(edge[, 1], edge[, 2], 4L)
ListAncestors(edge[, 1], edge[, 2], 8L)

# Ancestors of each node, if tree numbering system is uncertain:
lapply(seq_len(max(edge)), ListAncestors,
       parent = edge[, 1], child = edge[, 2])

# Ancestors of each node, if tree is in preorder:
ListAncestors(edge[, 1], edge[, 2])

# Alias:
AllAncestors(edge[, 1], edge[, 2])

}
\seealso{
Implemented less efficiently in \code{phangorn:::Ancestors}, on which this
code is based.

Other tree navigation: 
\code{\link{AncestorEdge}()},
\code{\link{CladeSizes}()},
\code{\link{DescendantEdges}()},
\code{\link{EdgeAncestry}()},
\code{\link{EdgeDistances}()},
\code{\link{MRCA}()},
\code{\link{MatchEdges}()},
\code{\link{NDescendants}()},
\code{\link{NodeDepth}()},
\code{\link{NodeNumbers}()},
\code{\link{NodeOrder}()},
\code{\link{RootNode}()}

Other tree navigation: 
\code{\link{AncestorEdge}()},
\code{\link{CladeSizes}()},
\code{\link{DescendantEdges}()},
\code{\link{EdgeAncestry}()},
\code{\link{EdgeDistances}()},
\code{\link{MRCA}()},
\code{\link{MatchEdges}()},
\code{\link{NDescendants}()},
\code{\link{NodeDepth}()},
\code{\link{NodeNumbers}()},
\code{\link{NodeOrder}()},
\code{\link{RootNode}()}
}
\author{
\href{https://orcid.org/0000-0001-5660-1727}{Martin R. Smith}
(\href{mailto:martin.smith@durham.ac.uk}{martin.smith@durham.ac.uk})
}
\concept{tree navigation}
