% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/kmeanspp.R
\name{KMeansPP}
\alias{KMeansPP}
\title{k-means++ clustering}
\usage{
KMeansPP(x, k = 2, nstart = 10, ...)
}
\arguments{
\item{x}{Numeric matrix of data, or an object that can be coerced to such a
matrix (such as a numeric vector or a data frame with all numeric columns).}

\item{k}{Integer specifying the number of clusters, \emph{k}.}

\item{nstart}{Positive integer specifying how many random sets should be
chosen}

\item{\dots}{additional arguments passed to \code{\link[stats]{kmeans}}}
}
\description{
k-means++ clustering \insertCite{Arthur2007}{TreeDist} improves the speed and
accuracy of standard \code{\link[stats]{kmeans}} clustering
\insertCite{Hartigan1979}{TreeDist} by preferring initial cluster centres
that are far from others.
A scalable version of the algorithm has been proposed for larger data sets
\insertCite{Bahmani2012}{TreeDist}, but is not implemented here.
}
\examples{
# Generate random points
set.seed(1)
x <- cbind(c(rnorm(10, -5), rnorm(5, 1), rnorm(10, 6)),
           c(rnorm(5, 0), rnorm(15, 4), rnorm(5, 0)))

# Conventional k-means may perform poorly
klusters <- kmeans(x, cent = 5)
plot(x, col = klusters$cluster, pch = rep(15:19, each = 5))

# Here, k-means++ recovers a better clustering
plusters <- KMeansPP(x, k = 5)
plot(x, col = plusters$cluster, pch = rep(15:19, each = 5))
}
\references{
\insertAllCited{}
}
\seealso{
\code{\link[stats]{kmeans}}

Other cluster functions: 
\code{\link{cluster-statistics}}
}
\author{
\href{https://orcid.org/0000-0001-5660-1727}{Martin R. Smith}
(\href{mailto:martin.smith@durham.ac.uk}{martin.smith@durham.ac.uk})
}
\concept{cluster functions}
