% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/gof.R
\name{gof}
\alias{gof}
\title{Compute goodness-of-fit measures between observed and simulated OD matrices}
\usage{
gof(
  sim,
  obs,
  measures = "all",
  distance = NULL,
  bin_size = 2,
  use_proba = FALSE,
  check_names = FALSE
)
}
\arguments{
\item{sim}{An object of class \code{TDLM} (output of \code{\link[=run_law_model]{run_law_model()}},
\code{\link[=run_law]{run_law()}}, or \code{\link[=run_model]{run_model()}}). A matrix or a list of matrices can also be
used (see Note).}

\item{obs}{A square \code{matrix} representing the observed mobility flows.}

\item{measures}{A \code{character} vector or a single \code{character} string
indicating which goodness-of-fit measure(s) to compute (see Details).
Available options are \code{"CPC"}, \code{"NRMSE"}, \code{"KL"}, \code{"CPL"}, \code{"CPC_d"} and
\code{"KS"}. If \code{"all"} is specified, all measures will be calculated.}

\item{distance}{A square \code{matrix} representing the distances between
locations. This is only necessary for distance-based measures.}

\item{bin_size}{A \code{numeric} value indicating the size of bins used to
discretize the distance distribution when computing CPC_d (default is 2
kilometers).}

\item{use_proba}{A \code{boolean} indicating whether the \code{proba} matrix should be
used instead of the simulated OD matrix to compute the measure(s). This is
only valid for output from \code{\link[=run_law_model]{run_law_model()}} with the argument
\code{write_proba = TRUE} (see Note).}

\item{check_names}{A \code{boolean} indicating whether the location IDs used as
matrix rownames and colnames should be checked for consistency
(see Note).}
}
\value{
A \code{data.frame} providing one or several goodness-of-fit measures between
simulated OD(s) and an observed OD. Each row corresponds to a matrix sorted
according to the list (or list of lists) elements (names are used if
provided).
}
\description{
This function returns a \code{data.frame} where each row provides one or
several goodness-of-fit measures between a simulated and an observed
Origin-Destination (OD) matrix.
}
\details{
Several goodness-of-fit measures are considered, such as the Common Part
of Commuters (CPC), the Common Part of Links (CPL), and the Common Part of
Commuters based on the distance (CPC_d), as described in \href{http://arxiv.org/abs/1506.04889}{Lenormand \emph{et al.} (2016)}. It also includes
classical metrics such as the
\href{https://rtdlm.github.io/TDLM/articles/TDLM.html#normalized-root-mean-square-error-nrmse}{Normalized Root Mean Square Error}
(NRMSE), the
\href{https://rtdlm.github.io/TDLM/articles/TDLM.html#kullbackleibler-divergence-ks}{Kullback–Leibler divergence}
(KL), and the Kolmogorov-Smirnov statistic and
p-value (KS). These measures are based on the observed and simulated flow
distance distributions and are computed using the \link[Ecume:ks_test]{ks_test}
function from the \href{https://cran.r-project.org/package=Ecume}{Ecume} package.
}
\note{
By default, if \code{sim} is an output of \code{\link[=run_law_model]{run_law_model()}},
the measure(s) are computed only for the simulated OD matrices and
not for the \code{proba} matrix (included in the output when
\code{write_proba = TRUE}). The argument \code{use_proba} can be used to compute the
measure(s) based on the \code{proba} matrix instead of the simulated
OD matrix. In this case, the argument \code{obs} should also be a \code{proba} matrix.

All inputs should be based on the same number of
locations, sorted in the same order. It is recommended to use the location ID
as \code{matrix} \code{rownames} and \code{matrix} \code{colnames} and to set
\code{check_names = TRUE} to verify that everything is consistent before running
this function (\code{check_names = FALSE} by default). Note that the function
\code{\link[=check_format_names]{check_format_names()}} can be used to validate all inputs
before running the main package's functions.
}
\examples{
data(mass)
data(distance)
data(od)

mi <- as.numeric(mass[, 1])
mj <- mi
Oi <- as.numeric(mass[, 2])
Dj <- as.numeric(mass[, 3])

res <- run_law_model(law = "GravExp", 
                     mass_origin = mi, 
                     mass_destination = mj,
                     distance = distance, 
                     opportunity = NULL, 
                     param = 0.01,
                     model = "DCM", 
                     nb_trips = NULL, 
                     out_trips = Oi, 
                     in_trips = Dj,
                     average = FALSE, 
                     nbrep = 1, 
                     maxiter = 50, 
                     mindiff = 0.01,
                     write_proba = FALSE,
                     check_names = FALSE)

gof(sim = res, 
    obs = od, 
    measures = "CPC", 
    distance = NULL, 
    bin_size = 2,
    use_proba = FALSE,
    check_names = FALSE)

}
\references{
Lenormand M, Bassolas A, Ramasco JJ (2016) Systematic comparison of trip
distribution laws and models. \emph{Journal of Transport Geography} 51,
158-169.
}
\seealso{
For more details illustrated with a practical example,
see the vignette:
\url{https://rtdlm.github.io/TDLM/articles/TDLM.html#goodness-of-fit-measures}.

Associated functions:
\code{\link[=run_law]{run_law()}}, \code{\link[=run_model]{run_model()}}, \code{\link[=run_law_model]{run_law_model()}}.
}
\author{
Maxime Lenormand (\email{maxime.lenormand@inrae.fr})
}
