% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/p_r.R
\name{p_r}
\alias{p_r}
\alias{gen_r}
\title{p-value from correlation simulation}
\usage{
p_r(n, r, rho = 0, method = "pearson", two.tailed = TRUE, gen_fun = gen_r, ...)

gen_r(n, r, ...)
}
\arguments{
\item{n}{sample size}

\item{r}{correlation}

\item{rho}{population coefficient to test against. Uses the
Fisher's z-transformation approximation when non-zero}

\item{method}{method to use to compute the correlation
(see \code{\link{cor.test}}). Only used when \code{rho = 0}}

\item{two.tailed}{logical; should a two-tailed or one-tailed test be used?}

\item{gen_fun}{function used to generate the required dependent bivariate data.
Object returned must be a \code{matrix} with two columns and \code{n} rows.
Default uses \code{\link{gen_r}} to generate conditionally
dependent data from a bivariate normal distribution.
User defined version of this function must include the argument \code{...}}

\item{...}{additional arguments to be passed to \code{gen_fun}. Not used
unless a customized \code{gen_fun} is defined}
}
\value{
a single p-value
}
\description{
Generates correlated X-Y data and returns a p-value to assess the null
of no correlation in the population. The X-Y data are generated
assuming a bivariate normal distribution.
}
\examples{

# 50 observations, .5 correlation
p_r(50, r=.5)
p_r(50, r=.5, method = 'spearman')

# test against constant other than rho = .6
p_r(50, .5, rho=.60)


\donttest{
    # compare simulated results to pwr package

    pwr::pwr.r.test(r=0.3, n=50)
    p_r(n=50, r=0.3) |> Spower()

    pwr::pwr.r.test(r=0.3, power=0.80)
    p_r(n=NA, r=0.3) |> Spower(power=.80, interval=c(10, 200))

    pwr::pwr.r.test(r=0.1, power=0.80)
    p_r(n=NA, r=0.1) |> Spower(power=.80, interval=c(200, 1000))

}

}
\seealso{
\code{\link{gen_r}}
}
\author{
Phil Chalmers \email{rphilip.chalmers@gmail.com}
}
