% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/notifications.R
\name{new_TelegramNotifier}
\alias{new_TelegramNotifier}
\title{Create a Telegram Notifier}
\usage{
new_TelegramNotifier(bot_token, chat_id, verbose_issues = FALSE)
}
\arguments{
\item{bot_token}{A character string representing your Telegram bot token, typically
something like \code{"123456:ABC-xxxx"}.}

\item{chat_id}{A character string or numeric representing the chat/group to send
messages to.}

\item{verbose_issues}{Logical. If TRUE, provides detailed information about warnings and errors in the notifications.}
}
\value{
An S3 object of class \code{"TelegramNotifier"}.
}
\description{
Constructs a notifier object for sending messages via Telegram.
Requires a valid Telegram bot token and chat ID.
}
\details{
To use send notifications over Telegram with \code{httr} in \code{SimDesign},
install \code{httr}, set set up a Telegram bot, and obtain a bot token and chat ID.
For more information, see the \href{https://core.telegram.org/bots}{Telegram Bots API}.
Then use the \code{new_TelegramNotifier()} function to create a \code{TelegramNotifier}
object and pass it to the \code{notifier} argument in \code{runSimulation()}.
}
\examples{
\dontshow{if (interactive()) (if (getRversion() >= "3.4") withAutoprint else force)(\{ # examplesIf}
# Create a Telegram notifier (requires setting up a Telegram Bot)
telegram_notifier <- new_TelegramNotifier(bot_token = "123456:ABC-xyz", chat_id = "987654321")
\dontshow{\}) # examplesIf}
}
