% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/paths.R
\name{stabilitySelection.SDForest}
\alias{stabilitySelection.SDForest}
\alias{stabilitySelection}
\title{Calculate the stability selection of an SDForest}
\usage{
\method{stabilitySelection}{SDForest}(object, cp_seq = NULL, ...)
}
\arguments{
\item{object}{an SDForest object}

\item{cp_seq}{A sequence of complexity parameters.
If NULL, the sequence is calculated automatically using only relevant values.}

\item{...}{Further arguments passed to or from other methods.}
}
\value{
An object of class \code{paths} containing
\item{cp}{The sequence of complexity parameters.}
\item{varImp_path}{A \code{matrix} with the stability selection
for each complexity parameter.}
\item{type}{Path type}
}
\description{
This function calculates the stability selection of an SDForest
\insertCite{Meinshausen2010StabilitySelection}{SDModels}.
Stability selection is calculated as the fraction of trees in the forest
that select a variable for a split at each complexity parameter.
}
\examples{
set.seed(1)
n <- 10
X <- matrix(rnorm(n * 5), nrow = n)
y <- sign(X[, 1]) * 3 + sign(X[, 2]) + rnorm(n)
model <- SDForest(x = X, y = y, Q_type = 'no_deconfounding', nTree = 2, cp = 0.5)
paths <- stabilitySelection(model)
plot(paths)
\donttest{
plot(paths, plotly = TRUE)
}
}
\references{
\insertAllCited{}
}
\seealso{
\code{\link{plot.paths}} \code{\link{regPath}} \code{\link{prune}} \code{\link{get_cp_seq}} \code{\link{SDForest}}
}
\author{
Markus Ulmer
}
