% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/bc.TSMBC.R
\name{TSMBC}
\alias{TSMBC}
\title{TSMBC (Time Shifted Multivariate Bias Correction)}
\description{
Perform a bias correction of auto-correlation
}
\details{
Correct auto-correlation with a shift approach.
}
\examples{

## arima model parameters
modelX0 = list( ar = base::c(  0.6 , 0.2 , -0.1 ) )
modelY0 = list( ar = base::c( -0.3 , 0.4 , -0.2 ) )

## arima random generator
rand.genX0 = function(n){ return(stats::rnorm( n , mean = 0.2 , sd = 1   )) }
rand.genY0 = function(n){ return(stats::rnorm( n , mean = 0   , sd = 0.7 )) }

## Generate two AR processes
X0 = stats::arima.sim( n = 1000 , model = modelX0 , rand.gen = rand.genX0 )
Y0 = stats::arima.sim( n = 1000 , model = modelY0 , rand.gen = rand.genY0 )
X0 = as.vector( X0 )
Y0 = as.vector( Y0 + 5 )

## And correct it with 30 lags
tsbc = SBCK::TSMBC$new( 30 )
tsbc$fit( Y0 , X0 )
Z0 = tsbc$predict(X0)

}
\references{
Robin, Y. and Vrac, M.: Is time a variable like the others in
            multivariate statistical downscaling and bias correction?, Earth
            Syst. Dynam. Discuss. [preprint],
            https://doi.org/10.5194/esd-2021-12, in review, 2021.
}
\section{Public fields}{
\if{html}{\out{<div class="r6-fields">}}
\describe{
\item{\code{shift}}{[Shift class] Shift class to shift data.}

\item{\code{bc_method}}{[SBCK::BC_method] Underlying bias correction method.}
}
\if{html}{\out{</div>}}
}
\section{Active bindings}{
\if{html}{\out{<div class="r6-active-bindings">}}
\describe{
\item{\code{method}}{[character] If inverse is by row or column, see class Shift}

\item{\code{ref}}{[integer] reference column/row to inverse shift, see class}
}
\if{html}{\out{</div>}}
}
\section{Methods}{
\subsection{Public methods}{
\itemize{
\item \href{#method-TSMBC-new}{\code{TSMBC$new()}}
\item \href{#method-TSMBC-fit}{\code{TSMBC$fit()}}
\item \href{#method-TSMBC-predict}{\code{TSMBC$predict()}}
\item \href{#method-TSMBC-clone}{\code{TSMBC$clone()}}
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-TSMBC-new"></a>}}
\if{latex}{\out{\hypertarget{method-TSMBC-new}{}}}
\subsection{Method \code{new()}}{
Create a new TSMBC object.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{TSMBC$new(lag, bc_method = OTC, method = "row", ref = "middle", ...)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{lag}}{[integer] max lag of autocorrelation}

\item{\code{bc_method}}{[SBCK::BC_METHOD] bias correction method to use after 
shift of data, default is OTC}

\item{\code{method}}{[character] If inverse is by row or column, see class Shift}

\item{\code{ref}}{[integer] reference column/row to inverse shift, see class
Shift. Default is 0.5 * (lag+1)}

\item{\code{...}}{[] All others arguments are passed to bc_method}
}
\if{html}{\out{</div>}}
}
\subsection{Returns}{
A new `TSMBC` object.
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-TSMBC-fit"></a>}}
\if{latex}{\out{\hypertarget{method-TSMBC-fit}{}}}
\subsection{Method \code{fit()}}{
Fit the bias correction method
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{TSMBC$fit(Y0, X0)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{Y0}}{[matrix: n_samples * n_features] Observations in calibration}

\item{\code{X0}}{[matrix: n_samples * n_features] Model in calibration}
}
\if{html}{\out{</div>}}
}
\subsection{Returns}{
NULL
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-TSMBC-predict"></a>}}
\if{latex}{\out{\hypertarget{method-TSMBC-predict}{}}}
\subsection{Method \code{predict()}}{
Predict the correction
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{TSMBC$predict(X0)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{X0}}{[matrix: n_samples * n_features or NULL] Model in calibration}
}
\if{html}{\out{</div>}}
}
\subsection{Returns}{
[matrix] Return the corrections of X0
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-TSMBC-clone"></a>}}
\if{latex}{\out{\hypertarget{method-TSMBC-clone}{}}}
\subsection{Method \code{clone()}}{
The objects of this class are cloneable with this method.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{TSMBC$clone(deep = FALSE)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{deep}}{Whether to make a deep clone.}
}
\if{html}{\out{</div>}}
}
}
}
