% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/parameter_estimation.R
\name{Laplace_sampling_MCMC}
\alias{Laplace_sampling_MCMC}
\title{Laplace Sampling Markov Chain Monte Carlo (MCMC) for Generalized Linear Gaussian Process Models}
\usage{
Laplace_sampling_MCMC(
  y,
  units_m,
  mu,
  Sigma,
  ID_coords,
  ID_re = NULL,
  sigma2_re = NULL,
  family,
  control_mcmc,
  Sigma_pd = NULL,
  mean_pd = NULL,
  messages = TRUE
)
}
\arguments{
\item{y}{Response variable vector.}

\item{units_m}{Units of measurement for the response variable.}

\item{mu}{Mean vector of the response variable.}

\item{Sigma}{Covariance matrix of the spatial process.}

\item{ID_coords}{Indices mapping response to locations.}

\item{ID_re}{Indices mapping response to unstructured random effects.}

\item{sigma2_re}{Variance of the unstructured random effects.}

\item{family}{Distribution family for the response variable. Must be one of 'gaussian', 'binomial', or 'poisson'.}

\item{control_mcmc}{List with control parameters for the MCMC algorithm:
\describe{
  \item{n_sim}{Number of MCMC iterations.}
  \item{burnin}{Number of burn-in iterations.}
  \item{thin}{Thinning parameter for saving samples.}
  \item{h}{Step size for proposal distribution. Defaults to 1.65/(n_tot^(1/6)).}
  \item{c1.h, c2.h}{Parameters for adaptive step size tuning.}
}}

\item{Sigma_pd}{Precision matrix (optional) for Laplace approximation.}

\item{mean_pd}{Mean vector (optional) for Laplace approximation.}

\item{messages}{Logical; if TRUE, print progress messages.}
}
\value{
An object of class "mcmc.RiskMap" containing:
  \describe{
    \item{samples$S}{Samples of the spatial process.}
    \item{samples$<re_names[i]>}{Samples of each unstructured random effect, named according to columns of ID_re if provided.}
    \item{tuning_par}{Vector of step size (h) values used during MCMC iterations.}
    \item{acceptance_prob}{Vector of acceptance probabilities across MCMC iterations.}
  }
}
\description{
Performs MCMC sampling using Laplace approximation for Generalized Linear Gaussian Process Models (GLGPMs).
}
\details{
This function implements a Laplace sampling MCMC approach for GLGPMs. It maximizes the integrand using `maxim.integrand` function for Laplace approximation if `Sigma_pd` and `mean_pd` are not provided.

The MCMC procedure involves adaptive step size adjustment based on the acceptance probability (`acc_prob`) and uses a Gaussian proposal distribution centered on the current mean (`mean_curr`) with variance `h`.
}
\author{
Emanuele Giorgi \email{e.giorgi@lancaster.ac.uk}

Claudio Fronterre \email{c.fronterr@lancaster.ac.uk}
}
