% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/hazrate.like.R
\name{hazrate.like}
\alias{hazrate.like}
\title{hazrate.like - Hazard rate likelihood}
\usage{
hazrate.like(a, dist, covars)
}
\arguments{
\item{a}{A vector or matrix of covariate 
and expansion term 
coefficients. Dimension is $k$ X $p$, where 
$k$ (i.e., \code{nrow(a)}) is the number of coefficient
vectors to evaluate (cases) and $p$ (i.e., \code{ncol(a)})
is the number of covariate and expansion 
coefficients in the likelihood. If \code{a} is a 
dimensionless vector, it is interpreted to be a 
single row with $k$ = 1. 
Covariate coefficients in \code{a} are the first 
$q$ values ($q$ <= $p$), and must be on a log scale.}

\item{dist}{A numeric vector of length $n$ or 
a single-column matrix (dimension $n$X1) containing 
detection distances at which to evaluate the likelihood.}

\item{covars}{A numeric vector of length $q$ or 
matrix of dimension $n$X$q$ containing covariate values 
associated with distances in argument \code{d}}
}
\value{
A list containing the following two components:
\itemize{
  \item \bold{L.unscaled}: A matrix of size $n$X$k$X$b$ 
   containing likelihood values evaluated at 
   distances in \code{dist}.
    Each row is associated with 
   a single distance, and each column is associated with 
   a single case (row of \code{a}).  This matrix is  
   "unscaled" because the underlying likelihood does 
   not integrate to one. Values in \code{L.unscaled} 
   are always greater than or equal to zero.
   
 \item \bold{params}: A $n$X$k$X$b$ array of the 
 likelihood's (canonical) parameters, First page contains 
 parameter values related to covariates (i.e., $s = exp(x'a)$),
 while subsequent pages contain other parameters. 
 $b$ = 1 for halfnorm, negexp; $b$ = 2 for hazrate and 
 others.
 Rows correspond to distances in \code{dist}. Columns 
 correspond to rows from argument \code{a}. 
}
}
\description{
Computes the hazard rate distance function.
}
\details{
The hazard rate likelihood is 
\deqn{f(x|\sigma,k) = 1 - \exp(-(x/\sigma)^{-k})}{%
f(x|Sigma,k) = 1 - exp(-(x/Sigma)^(-k))} 
where \eqn{\sigma}{Sigma} determines location 
(i.e., distance at which the function equals 1 - exp(-1) = 0.632), 
and \eqn{k}{k} determines slope of the function 
at \eqn{\sigma}{Sigma} (i.e., larger k equals steeper 
slope at \eqn{\sigma}{Sigma}). For distance analysis, 
the valid range for both \eqn{\sigma}{Sigma} and k is
\eqn{\geq 0}{>=0}.
}
\examples{
d <- seq(0, 100, length=100)
covs <- matrix(1,length(d),1)
hazrate.like(c(log(20), 5), d, covs)

# Changing location parameter
plot(d, hazrate.like(c(log(20), 5), d, covs)$L.unscaled, type="l", col="red")
lines(d, hazrate.like(c(log(40), 5), d, covs)$L.unscaled, col="blue")
abline(h = 1 - exp(-1), lty = 2)
abline(v = c(20,40), lty = 2)

# Changing slope parameter
plot(d, hazrate.like(c(log(50), 20), d, covs)$L.unscaled, type="l", col="red")
lines(d, hazrate.like(c(log(50), 2), d, covs)$L.unscaled, col="blue")
abline(h = 1 - exp(-1), lty = 2)
abline(v = 50, lty = 2)

         
}
\seealso{
\code{\link{dfuncEstim}},
         \code{\link{hazrate.like}},
         \code{\link{negexp.like}}
}
\keyword{models}
