% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/estimate_nearneighbor1.R
\name{est.nearneighbor1}
\alias{est.nearneighbor1}
\title{Intrinsic Dimension Estimation with Near-Neighbor Information}
\usage{
est.nearneighbor1(X, K = max(2, round(ncol(X)/5)))
}
\arguments{
\item{X}{an \eqn{(n\times p)} matrix or data frame whose rows are observations.}

\item{K}{maximum neighborhood size, smaller than \eqn{p}.}
}
\value{
a named list containing containing \describe{
\item{estdim}{estimated intrinsic dimension.}
}
}
\description{
Based on an assumption of data points being locally uniformly distributed,
\code{est.nearneighbor1} estimates the intrinsic dimension based on the
local distance information in an iterative manner.
}
\examples{
\donttest{
## create an example data with intrinsic dimension 2
X = cbind(aux.gensamples(dname="swiss"),aux.gensamples(dname="swiss"))

## acquire an estimate for intrinsic dimension
output = est.nearneighbor1(X)
sprintf("* est.nearneighbor1 : estimated dimension is \%.2f.",output$estdim)
}

}
\references{
\insertRef{pettis_intrinsic_1979}{Rdimtools}
}
\author{
Kisung You
}
