% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/Presto.R, R/dbConnect.R, R/dbDisconnect.R
\name{Presto}
\alias{Presto}
\alias{dbConnect,PrestoDriver-method}
\alias{dbDisconnect,PrestoConnection-method}
\title{Connect to a Presto database}
\usage{
Presto(...)

\S4method{dbConnect}{PrestoDriver}(
  drv,
  catalog,
  schema,
  user,
  host = "localhost",
  port = 8080,
  source = methods::getPackageName(),
  session.timezone = "",
  output.timezone = "",
  parameters = list(),
  ctes = list(),
  request.config = httr::config(),
  use.trino.headers = FALSE,
  extra.credentials = "",
  bigint = c("integer", "integer64", "numeric", "character"),
  ...
)

\S4method{dbDisconnect}{PrestoConnection}(conn)
}
\arguments{
\item{...}{currently ignored}

\item{drv}{A driver object generated by \code{\link[=Presto]{Presto()}}}

\item{catalog}{The catalog to be used}

\item{schema}{The schema to be used}

\item{user}{The current user}

\item{host}{The presto host to connect to}

\item{port}{Port to use for the connection}

\item{source}{Source to specify for the connection}

\item{session.timezone}{Time zone of the Presto server. Presto returns
timestamps without time zones with respect to this value. The time
arithmetic (e.g. adding hours) will also be done in the given time
zone. This value is passed to Presto server via the request headers.}

\item{output.timezone}{The time zone using which TIME WITH TZ and TIMESTAMP
values in the output should be represented. Default to the Presto
server timezone (use \verb{show(<PrestoConnection>)} to see).}

\item{parameters}{A \code{\link[=list]{list()}} of extra parameters to be passed in
the \sQuote{X-Presto-Session} header}

\item{ctes}{\ifelse{html}{\href{https://lifecycle.r-lib.org/articles/stages.html#experimental}{\figure{lifecycle-experimental.svg}{options: alt='[Experimental]'}}}{\strong{[Experimental]}}
A list of common table expressions (CTEs) that can be used in the
WITH clause. See \code{vignette("common-table-expressions")}.}

\item{request.config}{An optional config list, as returned by
\code{httr::config()}, to be sent with every HTTP request.}

\item{use.trino.headers}{A boolean to indicate whether Trino request headers
should be used. Default to FALSE.}

\item{extra.credentials}{Extra credentials to be passed in the
X-Presto-Extra-Credential or X-Trino-Extra-Credential header (
depending on the value of the use.trino.headers argument). Default
to an empty string.}

\item{bigint}{The R type that Presto's 64-bit integer (\code{BIGINT}) class should
be translated to. The default is \code{"integer"}, which returns R's
\code{integer} type, but results in \code{NA} for values above/below
+/-2147483647. \code{"integer64"} returns a \link[bit64:bit64-package]{bit64::integer64}, which
allows the full range of 64 bit integers. \code{"numeric"} coerces into
R's \code{double} type but might result in precision loss. Lastly,
\code{"character"} casts into R's \code{character} type.}

\item{conn}{A \linkS4class{PrestoConnection} object}
}
\value{
\link{Presto} A \linkS4class{PrestoDriver} object

\code{\link[DBI:dbConnect]{DBI::dbConnect()}} A \linkS4class{PrestoConnection} object

\code{\link[DBI:dbDisconnect]{DBI::dbDisconnect()}} A \code{\link[=logical]{logical()}} value indicating success
}
\description{
Connect to a Presto database
}
\examples{
\dontrun{
conn <- dbConnect(Presto(),
  catalog = "hive", schema = "default",
  user = "onur", host = "localhost", port = 8080,
  session.timezone = "US/Eastern", bigint = "character"
)
dbListTables(conn, "\%_iris")
dbDisconnect(conn)
}
}
