% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/get_sensor_history.R
\name{get_sensor_history}
\alias{get_sensor_history}
\title{get sensor history}
\usage{
get_sensor_history(
  sensor_index,
  fields,
  start_timestamp,
  end_timestamp,
  average = c("10min", "30min", "60min", "6hr", "1day", "1week", "1month", "1year",
    "real-time"),
  purple_air_api_key = Sys.getenv("PURPLE_AIR_API_KEY"),
  read_key = NULL
)
}
\arguments{
\item{sensor_index}{Integer (or numeric, character object coerceable to integer) \code{sensor_index}}

\item{fields}{A character vector of which 'sensor data fields' to return}

\item{start_timestamp}{time stamp of first required history entry (inclusive)}

\item{end_timestamp}{end time stamp of history to return (exclusive)}

\item{average}{time frame to request averaged results for}

\item{purple_air_api_key}{A character that is your PurpleAir API \code{READ} key}

\item{read_key}{A character key required to read data from private devices}
}
\value{
a list of sensor data, named by the provided \code{fields}
}
\description{
Retrieves the latest history of a single sensor matching the provided \code{sensor_index}.
Find more details on sensor fields at https://api.purpleair.com/#api-sensors-get-sensor-history.
}
\examples{
\dontrun{
get_sensor_history(
  sensor_index = 175413,
  fields = c("pm1.0_cf_1", "pm1.0_atm", "pm2.5_cf_1", "pm2.5_atm"),
  start_timestamp = as.POSIXct("2024-07-02"),
  end_timestamp = as.POSIXct("2024-07-05")
)
}
}
