% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/render.R
\name{pt2_render}
\alias{pt2_render}
\alias{pt2_render.pt2mod}
\alias{pt2_render.pt2samp}
\alias{pt2_render.pt2patlist}
\alias{pt2_render.pt2pat}
\alias{pt2_render.pt2celllist}
\alias{pt2_render.pt2cell}
\title{Render ProTracker modules and other objects to a playable format}
\usage{
pt2_render(x, duration = NA, options = pt2_render_options(), ...)

\method{pt2_render}{pt2mod}(
  x,
  duration = NA,
  options = pt2_render_options(),
  position = 0L,
  ...
)

\method{pt2_render}{pt2samp}(x, duration = 5, options = pt2_render_options(), note = "C-3", ...)

\method{pt2_render}{pt2patlist}(x, duration = NA, options = pt2_render_options(), samples, ...)

\method{pt2_render}{pt2pat}(x, duration = NA, options = pt2_render_options(), samples, ...)

\method{pt2_render}{pt2celllist}(x, duration = 5, options = pt2_render_options(), samples, ...)

\method{pt2_render}{pt2cell}(x, duration = 5, options = pt2_render_options(), samples, ...)
}
\arguments{
\item{x}{The object to be rendered}

\item{duration}{Duration of the rendered output in seconds. When set to \code{NA}
the duration of the module is calculated and used for rendering.}

\item{options}{A list of options used for rendering the audio. Use
\code{\link[=pt2_render_options]{pt2_render_options()}} to obtain default options, or modify them.}

\item{...}{Ignored}

\item{position}{Starting position in the pattern sequence table (\code{pt2_pattern_table()}).
Should be a non negative value smaller than the mule length (\code{pt2_length()}).}

\item{note}{Note to be played when \code{x} is a \code{pt2samp} class object. Defaults
to \code{"C-3"}.}

\item{samples}{When rendering or playing patterns (or elements of it), samples are needed
to interpret the pattern. Pass the samples as a sample list (class \code{pt2samplist}).}
}
\value{
Rendered audio inheriting the \code{\link[audio:audioSample]{audio::audioSample()}} class.
}
\description{
Renders a 16bit pulse-code modulation waveform from a ProTracker module.
The rendered format can be played on a modern machine.
}
\examples{
mod <- pt2_read_mod(pt2_demo())
aud <- pt2_render(mod)
aud_samp <- pt2_render(mod$samples[[1]])
}
\author{
Pepijn de Vries
}
