% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/simDNetwork.R
\name{sim.dnetwork}
\alias{sim.dnetwork}
\title{Simulation of the distribution of the network for Breza et al. (2020)}
\usage{
sim.dnetwork(nu, d, zeta, z)
}
\arguments{
\item{nu}{is the vector of gregariousness.}

\item{d}{is the vector of degrees.}

\item{zeta}{is a scale parameter that captures the influence of the latent positions on the link probabilities.}

\item{z}{is a matrix where each row is a spherical coordinate.}
}
\value{
a matrix of linking probabilities.
}
\description{
Compute the distribution of the network following  McCormick and Zheng (2015) and Breza et al. (2020).
}
\examples{
N       <- 500 
zeta    <- 1

# Generate the spherical coordinates
z       <- rvMF(N, c(0, 0, 0))

# Genetate the gregariousness
nu      <- rnorm(N, -1.35, 0.37)

# Generate degrees
d       <- runif(N, 0, 45)

dist    <- sim.dnetwork(nu, d, zeta, z)
}
\seealso{
\code{\link{sim.network}}
}
