% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/power_transform.R
\name{power_transform}
\alias{power_transform}
\title{Apply Power Transformation to Numeric Data}
\usage{
power_transform(
  data,
  family = c("bcPower", "bcnPower", "yjPower"),
  type = c("optimal", "rounded")
)
}
\arguments{
\item{data}{A numeric vector, matrix, or data frame. Only numeric columns will be transformed. Non-numeric columns are dropped with a warning.}

\item{family}{A character string specifying the transformation family. Must be one of \code{"bcPower"}, \code{"bcnPower"}, or \code{"yjPower"}.}

\item{type}{A character string specifying whether to use the estimated optimal lambda values (\code{"optimal"}) or the rounded values (\code{"rounded"}).}
}
\value{
A list containing two elements. The first is a data frame of transformed numeric columns. The second is a named numeric vector of the lambda values used for the transformation.
}
\description{
Applies a power transformation to numeric input data using the \code{car::powerTransform} function. Supported transformation families include Box-Cox (\code{"bcPower"}), Box-Cox with negative values (\code{"bcnPower"}), and Yeo-Johnson (\code{"yjPower"}). The function estimates either optimal or rounded lambda values for each numeric variable and transforms the data accordingly.
}
\details{
Rows with missing values are removed prior to estimating lambda parameters. A warning is issued if any non-numeric columns are dropped or if any rows are excluded due to missingness. The same estimated lambda values are then applied to the original data (excluding dropped rows or columns).
}
\examples{
if (requireNamespace("car", quietly = TRUE)) {
  x <- rnorm(100, mean = 10, sd = 2)
  y <- rexp(100, rate = 0.2)
  df <- data.frame(x = x, y = y)
  result <- power_transform(df, family = "bcPower", type = "optimal")
  head(result$data)
  result$lambda
}

}
