% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/network_analysis.R
\name{network_analysis}
\alias{network_analysis}
\title{Conduct Network analysis based on tax summary object}
\usage{
network_analysis(
  taxobj,
  taxlevel,
  reads = FALSE,
  n,
  threshold,
  rel_threshold = 0,
  method = "spearman",
  display = TRUE
)
}
\arguments{
\item{taxobj}{tax summary objects computed by \code{\link{tax_summary}}.}

\item{taxlevel}{taxonomy levels used for analysis. Must be one of c("Domain","Phylum","Class","Order","Family","Genus","Species","Base")}

\item{reads}{Logical,default:FALSE. Taxonomy abundance type used in analysis.FALSE for relative abundance, TRUE for absolute abundance.}

\item{n}{Numeric. Number of sample size indicating kept asv/otu/gene/taxa appearing. Recommended to set more than half of total sample size.}

\item{threshold}{Numeric.Threshold of absolute correlation value (r value for pearson method and rho value for spearman method).}

\item{rel_threshold}{Numeric.Threshold of relative abundance included in the network analysis.Default:0}

\item{method}{Character, default: "spearman". A character indicating which correlation coefficient method to be computed. One of "pearson" or "spearman"}

\item{display}{Logical, default:TRUE. If display a preview plot of network based on igraph. FALSE for the first attempt is recommended in case of too many vertices and edges.}
}
\value{
One list contains nodes information table, adjacency column table, adjacency matrix and 'igraph' object.
}
\description{
Conduct Network analysis based on tax summary object
}
\details{
\enumerate{
\item We had optimized the correlation algorithm to achieve a faster running speed. It takes less than 2 minute to calculate dataframe correlation and p value which more than 400 samples and 10000 OTUs for computer with dual Core i5 processor.
However, too many vertices(>2000) or links(>10000) may slow the statistical process and visualization,so we recommend that in your first attempt,set \code{display} paramter as \code{F} to have a preview.
Then you can adjust your n/threshold/method paramter to generate a suitable visualization network
\item We display a preview plot so as to adjusting your network. Generally a global figure (like we show in examples) with less than 1000 vertices and 5000 edges/links
is recommended. Further more,we recommend you to output the statistics and adjacency table and use software like cytoscape or gephi for better visualization.
}
}
\note{
\enumerate{
\item Replicates should be at least 5,more than 8 is recommend.
\item In case of too many edges/links or not a global network plot, you can stop the process immediately to provent wasting too much time.
}
}
\examples{
{
  ### Data preparation ###
  data("Two_group")
  set.seed(999)
  ## Analysis
  network_results <- network_analysis(
    taxobj = Two_group,
    taxlevel = "Genus",
    n = 10,
    threshold = 0.8
  )

  # Nodes information table
  network_nodes <- network_results$Nodes_info
  head(network_nodes)

  # Adjacency table
  network_adjacency <- network_results$Adjacency_column_table
  head(network_adjacency)

  # Complete adjacency matrix
  network_matrix <- network_results$Adjacency_matrix
  print(network_matrix[1:10, 1:10])

  # igraph object
  igraph_object <- network_results$Igraph_object
  network_stat(igraph_object)  # In case you want to see statistics again
  # or do other analysis based on igraph.
}
}
