% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/get_japan_child_mortality.R
\name{get_japan_child_mortality}
\alias{get_japan_child_mortality}
\title{Get Under-5 Mortality Rate in Japan from World Bank}
\source{
World Bank Open Data API: \url{https://data.worldbank.org/indicator/SH.DYN.MORT}
}
\usage{
get_japan_child_mortality()
}
\value{
A tibble with the following columns:
\itemize{
  \item \code{indicator}: Indicator name (e.g., "Mortality rate, under-5 (per 1,000 live births)")
  \item \code{country}: Country name ("Japan")
  \item \code{year}: Year of the data (integer)
  \item \code{value}: Under-5 mortality rate per 1,000 live births (numeric)
}
}
\description{
Retrieves Japan's under-five mortality rate (per 1,000 live births)
for the years 2010 to 2022 using the World Bank Open Data API.
The indicator used is \code{SH.DYN.MORT}.
}
\details{
This function sends a GET request to the World Bank API.
If the API request fails or returns an error status code,
the function returns \code{NULL} with an informative message.
}
\note{
Requires internet connection.
}
\examples{
if (interactive()) {
  get_japan_child_mortality()
}

}
\seealso{
\code{\link[httr]{GET}}, \code{\link[jsonlite]{fromJSON}}, \code{\link[dplyr]{as_tibble}}
}
