% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/AllClasses.R
\docType{class}
\name{bincap-class}
\alias{bincap-class}
\title{Binary Class and Prediction Objects}
\description{
S4 class for a binary class response and corresponding (predicted)
probabilities.
}
\note{
No defaults are set. Especially, you have to explicitly initialize
\code{true}, there is no trying to guess it from the \code{levels} of
\code{response}.
}
\section{Objects from the Class}{
 Objects can be created by calls of the form
\code{new("bincap", ...)}. They are used to store a binary class response
(one
of the two \code{levels} of which is supposed to be \code{true}), the
information which of the two \code{levels} of the binary class response is
thought of as 'true'/'positive'/'present' (the other one would then be
thought of as 'false'/'negative'/'absence') and the predicted probabilities
that \code{response} is \code{true}.
}

\examples{

showClass("bincap")
}
\seealso{
\code{\link[=cap-class]{class?HandTill2001::cap}} ,
\code{\link[=multcap-class]{class?HandTill2001::multcap}} ,
\code{\link[=bincap]{?HandTill2001::bincap}}
}
\keyword{classes}
