\name{cigar_tablet}
\alias{cigar_tablet}
\title{Cigar Tablet function for optimization problems}

\usage{
cigar_tablet(x)
}

\arguments{
\item{x}{
  A numeric vector of parameters for which the Cigar Tablet function is evaluated.
  }
}

\value{
Returns a numeric value, which is the evaluation of the Cigar Tablet function at the input vector \code{x}.
}

\description{
The Cigar Tablet function is a variant of the Cigar function, designed to present an additional challenge for optimization algorithms. This function features a narrow valley with varying scales in different directions, making it difficult for algorithms to converge due to the anisotropy of the problem.
}

\examples{

# Evaluation 1: Global minimum point in a four-dimensional space
x <- rep(0, 4)
cigar_tablet(x)

# Evaluation 2: A point in a six-dimensional space
x <- c(0, 0.24, 11, -1, -0.7, pi)
cigar_tablet(x)

# Contour Plot: Visualizing the Cigar Tablet Function
x1 <- seq(-10, 10, length.out = 100)
x2 <- seq(-10, 10, length.out = 100)
z <- outer(x1, x2, FUN = Vectorize(function(x, y) cigar_tablet(c(x, y))))
contour(x1, x2, z, nlevels = 20, main = "Contour of the Cigar Tablet Function")

# EDA.mnorm() example
res = EDA.mnorm(fun = cigar_tablet, lower = c(-10,-10), upper = c(10,10), n = 30, 
                k = 2, tolerance = 0.01, maxiter = 200)
res$sol

# Contour plot: Visualizing solution with EDA.mnorm()
x1 <- seq(-10, 10, length.out = 100)
x2 <- seq(-10, 10, length.out = 100)
z <- outer(x1, x2, FUN = Vectorize(function(x, y) cigar_tablet(c(x, y))))
contour(x1, x2, z, nlevels = 20, cex.axis = 0.8, 
        main = "Contour plot of the Cigar Tablet Function with EDA.mnorm solution")
points(res$sol[1], res$sol[2], col = "red", pch = 19)
}

\references{
{Auger, A., & Hansen, N. (2005). \emph{A restart CMA evolution strategy with increasing population size}. In The 2005 IEEE Congress on Evolutionary Computation, Vol. 2, pp. 1769-1776.}
}
