% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/list2CubeOfCov.R
\name{list2CubeOfCovDis}
\alias{list2CubeOfCovDis}
\title{compute a cube of covariance and a cube of distance
between the items (rows) of a matrix of measurements 
comprising \eqn{K} different blocks of possibly different
number of variables.}
\usage{
list2CubeOfCovDis(Data, Judges, scale = TRUE, center = TRUE, ev.scale = TRUE)
}
\arguments{
\item{Data}{a matrix of dimensions
\eqn{I} items by \eqn{J} quantitative variables
 (structured in \eqn{K} blocks of \eqn{J_k} variables
 each). No Default.}

\item{Judges}{a \eqn{J} components character 
vector identifiying the
variables corresponding to each block of variables.
No Default.}

\item{scale}{(Default: \code{TRUE}), when \code{TRUE}
scale to norm 1 each column for each slice.}

\item{center}{(Default: \code{TRUE}), when \code{TRUE}
centers each column.}

\item{ev.scale}{(Default: \code{TRUE}), when \code{TRUE}
normalizes each slice 
(i.e., each \eqn{I} items by \eqn{J}  matrix) so that its first 
eigenvalue is equal to 1.}
}
\value{
a list with 1) \code{cubeOfCovariance}
a cube of \eqn{K}  \eqn{I} by \eqn{I} covariance matrices;
and 2) code{cubeOfDistance}
a cube of \eqn{K}  \eqn{I} by \eqn{I} 
(squared) Euclidean distance
  matrices.
}
\description{
\code{list2CubeOfCovDis}
compute a cube of covariance and a cube of 
(squared) Euclidean distance
between the items (rows) a matrix of measurements 
comprising \eqn{K} different blocks of possibly different
number of variables.
The variables describing the items can scaled to norm 1
and centered. The whole matrix for a block 
can  be scaled by its first eigenvalue
(a la DISTATIS). Blocks can have different number of variables and
when all blocks have same number
of variables \code{list2CubeOfCovDis} 
is a more efficient alternative
}
\details{
The input of  \code{list2CubeOfCovDis} is a 
\eqn{I} items by \eqn{J} quantitative variables
that are organized in \eqn{K} blocks (i.e., submatrices)
each comprising \eqn{J_k} variables (with sum \eqn{J_k = J}).

By default  \code{list2CubeOfCovDis}
centers and normalizes each column for each block
and then normalize each covariance matrix such that
the first eigenvalue of each covariance matrix 
(for a given block) is equal to 1.
 
A \code{distatis} analysis of the Distance matrices with
the option \code{Distance = TRUE} will give the same results
as the \code{distatis} analysis of the Covariance matrices with
the option \code{Distance = FALSE}.
}
\examples{
path2file <- system.file("extdata",
                        "BeersFlashProfile.xlsx", 
                        package = 'DistatisR')
# read the data in the excel file with read.df.excel
beerDataFlash  <- read.df.excel(path = path2file,
                               sheet = 'Rankings')$df.data
# Extract the namers of the judges (first 2 characters)
JudgesVars <- colnames(beerDataFlash)
zeJudges <- substr(JudgesVars,1,2)
 # call list2CubeOfCovDis
test.list2 <- list2CubeOfCovDis(Data = beerDataFlash ,
                               Judges =  zeJudges)
}
\seealso{
list2CubeOfCov
}
\author{
Herve Abdi
}
