% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/DataHash.R
\name{computeDataHash}
\alias{computeDataHash}
\title{Compute hash of data}
\usage{
computeDataHash(connection, databaseSchema, tables = NULL, progressBar = TRUE)
}
\arguments{
\item{connection}{The connection to the database server created using either
\code{\link[=connect]{connect()}} or \code{\link[DBI:dbConnect]{DBI::dbConnect()}}.}

\item{databaseSchema}{The name of the database schema. See details for platform-specific details.}

\item{tables}{(Optional) A list of tables to restrict to.}

\item{progressBar}{When true, a progress bar is shown based on the number of tables
in the database schema.}
}
\value{
A string representing the MD5 hash code.
}
\description{
Compute a hash of the data in the database schema. If the data changes, this
should produce a different hash code. Specifically, the hash is based on the
field names, field types, and table row counts.
}
\details{
The \code{databaseSchema} argument is interpreted differently according to the different platforms:
SQL Server and PDW: The databaseSchema schema should specify both the database and the schema, e.g.
'my_database.dbo'. Impala: the databaseSchema should specify the database. Oracle:
The databaseSchema should specify the Oracle 'user'. All other : The databaseSchema should
specify the schema.
}
