% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/requireTableIntersect.R
\name{requireTableIntersect}
\alias{requireTableIntersect}
\title{Require cohort subjects are present in another clinical table}
\usage{
requireTableIntersect(
  cohort,
  tableName,
  window,
  intersections = c(1, Inf),
  cohortId = NULL,
  indexDate = "cohort_start_date",
  targetStartDate = startDateColumn(tableName),
  targetEndDate = endDateColumn(tableName),
  inObservation = TRUE,
  censorDate = NULL,
  atFirst = FALSE,
  name = tableName(cohort)
)
}
\arguments{
\item{cohort}{A cohort table in a cdm reference.}

\item{tableName}{Name of the table to check for intersect.}

\item{window}{A list of vectors specifying minimum and maximum days from
\code{indexDate} to consider events over.}

\item{intersections}{A range indicating number of intersections for
criteria to be fulfilled. If a single number is passed, the number of
intersections must match this.}

\item{cohortId}{Vector identifying which cohorts to modify
(cohort_definition_id or cohort_name). If NULL, all cohorts will be
used; otherwise, only the specified cohorts will be modified, and the
rest will remain unchanged.}

\item{indexDate}{Name of the column in the cohort that contains the date to
compute the intersection.}

\item{targetStartDate}{Start date of reference in cohort table.}

\item{targetEndDate}{End date of reference in cohort table. If NULL,
incidence of target event in the window will be considered as intersection,
otherwise prevalence of that event will be used as intersection (overlap
between cohort and event).}

\item{inObservation}{If TRUE only records inside an observation period will
be considered}

\item{censorDate}{Whether to censor overlap events at a specific date or a
column date of the cohort.}

\item{atFirst}{If FALSE the requirement will be applied to all records, if
TRUE, it will only be required for the first entry of each subject.}

\item{name}{Name of the new cohort table created in the cdm object.}
}
\value{
Cohort table
}
\description{
\code{requireTableIntersect()} filters a cohort table based on a requirement
that an individual is seen (or not seen) to have a record (or no records) in
a clinical table in some time window around an index date.
}
\examples{
\donttest{
library(CohortConstructor)
if(isTRUE(omock::isMockDatasetDownloaded("GiBleed"))){
cdm <- mockCohortConstructor()

cdm$cohort1 |>
  requireTableIntersect(tableName = "drug_exposure",
                            indexDate = "cohort_start_date",
                            window = c(-Inf, 0))
}
}
}
