% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/RcppExports.R
\name{bdapply_Function_hdf5}
\alias{bdapply_Function_hdf5}
\title{Apply function to different datasets inside a group}
\usage{
bdapply_Function_hdf5(
  filename,
  group,
  datasets,
  outgroup,
  func,
  b_group = NULL,
  b_datasets = NULL,
  overwrite = FALSE,
  transp_dataset = FALSE,
  transp_bdataset = FALSE,
  fullMatrix = FALSE,
  byrows = FALSE,
  threads = 2L
)
}
\arguments{
\item{filename}{Character array, indicating the name of the file to create}

\item{group}{Character array, indicating the input group where the data set
to be imputed is}

\item{datasets}{Character array, indicating the input datasets to be used}

\item{outgroup}{Character array, indicating group where the data set will
be saved after imputation. If NULL, output dataset is stored
in the same input group}

\item{func}{Character array, function to be applied:
- "QR": QR decomposition via bdQR()
- "CrossProd": Cross product via bdCrossprod()
- "tCrossProd": Transposed cross product via bdtCrossprod()
- "invChol": Inverse via Cholesky decomposition
- "blockmult": Matrix multiplication
- "CrossProd_double": Cross product with two matrices
- "tCrossProd_double": Transposed cross product with two matrices
- "solve": Matrix equation solving
- "sdmean": Standard deviation and mean computation}

\item{b_group}{Optional character array indicating the input group for
secondary datasets (used in two-matrix operations)}

\item{b_datasets}{Optional character array indicating the secondary datasets
for two-matrix operations}

\item{overwrite}{Optional boolean. If true, overwrites existing results}

\item{transp_dataset}{Optional boolean. If true, transposes first dataset}

\item{transp_bdataset}{Optional boolean. If true, transposes second dataset}

\item{fullMatrix}{Optional boolean for Cholesky operations. If true, stores
complete matrix; if false, stores only lower triangular}

\item{byrows}{Optional boolean for statistical operations. If true, computes
by rows; if false, by columns}

\item{threads}{Optional integer specifying number of threads for parallel processing}
}
\value{
Modifies the HDF5 file in place, adding computed results
}
\description{
This function provides a unified interface for applying various mathematical
operations to HDF5 datasets. It supports both single-dataset operations and
operations between multiple datasets.
}
\details{
//' For matrix multiplication operations (\code{blockmult}, \code{CrossProd_double}, \code{tCrossProd_double}),
the \code{datasets} and \code{b_datasets} vectors must have the same length. Each operation is performed
element-wise between the corresponding pairs of datasets. Specifically, the \code{b_datasets} vector
defines the second operand for each matrix multiplication. For example, if
\verb{datasets = \{"A1", "A2", "A3"\}} and \verb{b_datasets = \{"B1", "B2", "B3"\}}, the operations
executed are: \code{A1 \%*\% B1}, \code{A2 \%*\% B2}, and \code{A3 \%*\% B3}.

Example: If \verb{datasets = \{"A1", "A2", "A3"\}} and \verb{b_datasets = \{"B1", "B2", "B3"\}},
the function computes: \code{A1 \%*\% B1}, \code{A2 \%*\% B2}, and \code{A3 \%*\% B3}
}
\note{
Performance is optimized through:
- Block-wise processing for large datasets
- Parallel computation where applicable
- Memory-efficient matrix operations
}
\examples{
\dontrun{
# Create a sample large matrix in HDF5
# Create hdf5 datasets
bdCreate_hdf5_matrix(filename = "test_temp.hdf5", 
                    object = Y, group = "data", dataset = "Y",
                    transp = FALSE,
                    overwriteFile = TRUE, overwriteDataset = TRUE, 
                    unlimited = FALSE)

bdCreate_hdf5_matrix(filename = "test_temp.hdf5", 
                    object = X,  group = "data",  dataset = "X",
                    transp = FALSE,
                    overwriteFile = FALSE, overwriteDataset = TRUE, 
                    unlimited = FALSE)

bdCreate_hdf5_matrix(filename = "test_temp.hdf5",
                    object = Z,  group = "data",  dataset = "Z",
                    transp = FALSE,
                    overwriteFile = FALSE, overwriteDataset = TRUE,
                    unlimited = FALSE)

dsets <- bdgetDatasetsList_hdf5("test_temp.hdf5", group = "data")
dsets

# Apply function :  QR Decomposition
bdapply_Function_hdf5(filename = "test_temp.hdf5",
                     group = "data",datasets = dsets,
                     outgroup = "QR",func = "QR",
                     overwrite = TRUE)
}

}
