% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/plot.BchronCalibratedDates.R
\name{plot.BchronCalibratedDates}
\alias{plot.BchronCalibratedDates}
\title{Plot calibrated dates from a BchronCalibrate run}
\usage{
\method{plot}{BchronCalibratedDates}(
  x,
  date = NULL,
  withPositions = ifelse(length(x) > 1 & !is.null(x[[1]]$positions) & !includeCal, TRUE,
    FALSE),
  includeCal = FALSE,
  dateHeight = 100,
  dateLabels = TRUE,
  dateLabelSize = 2,
  nudgeX = 0,
  nudgeY = 0,
  fillCol = rgb(47/255, 79/255, 79/255, 0.5),
  withHDR = TRUE,
  ageScale = c("bp", "bc", "b2k"),
  scaleReverse = TRUE,
  pathToCalCurves = system.file("data", package = "Bchron"),
  ...
)
}
\arguments{
\item{x}{Output from \code{\link{BchronCalibrate}}}

\item{date}{Either numbers or date names to plot (only used if multiple dates have been calibrated)}

\item{withPositions}{Whether to plot with positions (i.e. using the position values as the y axis). By default TRUE if \code{x} has more than one date and contains positions}

\item{includeCal}{Whether to plot the date alongside the calibration curve (with 95\% uncertainty bands) and the normally distributed uncalibrated date.}

\item{dateHeight}{The height of the dates in the plot in the same units as the position values. Only relevant if \code{withPositions=TRUE}.}

\item{dateLabels}{Whether to add the names of the dates to the left of them. Default TRUE}

\item{dateLabelSize}{Size of the date labels}

\item{nudgeX}{The amount to move the date labels in the x direction. Can be negative. See \code{\link[ggplot2]{geom_text}} for details}

\item{nudgeY}{The amount to move the date labels in the y direction. Can be negative. See \code{\link[ggplot2]{geom_text}} for details}

\item{fillCol}{A colour to fill the date densities when \code{withPositions} is TRUE, or HDR ranges when it is FALSE}

\item{withHDR}{Whether to plot the 95\% highest density region values}

\item{ageScale}{Either \code{bp} for years before present, \code{bc} for years BC/AD (BC will be negative), \code{b2k} for years before 2000. Others not supported (yet).}

\item{scaleReverse}{Whether to reverse the x-axis scale. Defaults to TRUE which works best for dates presented in e.g. years BP}

\item{pathToCalCurves}{The Bchron path to calibration curves. Defaults to the package location might need to be set to another folder if user defined calibration curves are being used}

\item{...}{Other arguments to plot (currently ignored)}
}
\value{
A ggplot object containing the plot of the calibrated dates
}
\description{
Plots calibrated radiocarbon dates from a \code{\link{BchronCalibrate}} run. Has options to plot on a position (usually depth) scale if supplied with the original run
}
\details{
These plots are intended to be pretty basic and used simply for quick information. Users are encouraged to learn the R plotting features to produce publication quality graphics
}
\seealso{
\code{\link{BchronCalibrate}}, \code{\link{Bchronology}}, \code{\link{BchronRSL}}, \code{\link{BchronDensity}}, \code{\link{BchronDensityFast}}
}
