#' Pediatric T-ALL Omics Data from COG trial AALL0434
#'
#' A subset of genomic lesion and RNA expression data from pediatric and young
#'     adult t-lineage acute lymphoblastic leukmia patients in the Children's
#'     Oncology Group trial AALL0434, published in Liu et al., 2017 Nature
#'     Genetics
#'
#' @format ## `omicdat`
#' A list with two dataframes of omic data for each subject
#' \describe{
#'   \item{Lesion}{A dataframe with 20 rows and 265 columns indicating presence of lesion.}
#'   \item{RNA}{A dataframe with 20 rows and 265 columns with expression data.}
#' }
#' @source <https://www.nature.com/articles/ng.3909>
"omicdat"
